/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * bbuf2dekdata.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

int bbuf2dekdata(dekbb, edek)
struct bbuf *dekbb;
struct bbuf **edek;
{
    struct ccbent *ce = NULL_CCBENT;
    struct key *dek= NULL_KEY;
    int alg, ret= NOTOK;

    if (dekbb == NULLBB || edek == (struct bbuf **)0) 
	goto cleanup;

    if (decode_key(*edek, &dek) != OK) 
	goto cleanup;

    if (dek->algid == NULL_ALGID) 
	goto cleanup;

    alg = dek->algid->alg;

    /* GET ALGORITHM TABLE ENTRY */
    if ((ce = getccbcode(callbacks, alg)) == NULL_CCBENT) 
	goto cleanup;

    if (ce->bbuf2Xdata == NULL_FUNC) 
	goto cleanup;

    /* CONVERT THE BBUF TO KEY DATA */
    if ((ret = (*(ce->bbuf2Xdata))(dekbb, &dek)) == OK)
	ret = encode_key(dek, edek);

 cleanup:

    FREE_KEY(dek);
    return(ret);
}

/*****************************************************************************/
