/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 * decipher_key.c
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "crypto.h"
#include "util.h"

decipher_key(aid, key, pw, deciphered_key)
struct algid	*aid;
struct bbuf 	*key;
char		*pw;
struct bbuf 	**deciphered_key;
{
    int ret = NOTOK;
    struct bbuf *enckey = NULLBB;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (key == NULLBB || deciphered_key == (struct bbuf **)0) 
	goto cleanup;

    FREE_BBUF(*deciphered_key);

    /* SIMPLY DUP KEY IF NO PASSWORD PROVIDED */
    if ((pw == NULLCP) || (*pw == NULLC)) {
	ret = ((*deciphered_key = dup_bbuf(key)) != NULLBB) ? OK : NOTOK;
	goto cleanup;
    }

    /* CONVERT PASSWORD TO KEY */
    if (str2key(aid, pw, &enckey) != OK)
        goto cleanup;

    /* SET DES KEY AS DECRYPTION KEY */
    if (set_key(enckey) != OK)
        goto cleanup;

    /* DECRYPT THE ENCODED KEY */
    ret = decipher(key, deciphered_key);

 cleanup:

    if (ret != OK)
	FREE_BBUF(*deciphered_key);
    FREE_BBUF(enckey);

    return(ret);
}

/****************************************************************************/
