/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 * deciph_rsa.c
 ****************************************************************************/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./rsa.h"

int decipher_rsa(in, out)
struct bbuf *in;
struct bbuf **out;
{
    int r;
    R_RSA_PRIVATE_KEY Pr;
    unsigned char tmp[MAX_RSA_MODULUS_LEN];
    unsigned int tmplen;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (in == NULLBB || out == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*out);

    /* PREDECODE RSA KEY DATA */
    if ((r = predecode_rsakeydata(curdata, &curalg)) != OK)
	return(r);

    /* DECODE RSA PRIVATE KEY DATA */
    switch (curalg) {
    case RSA_PRIV:
    case RSAENC_PRIV:
        if ((r = decode_rsaprikeydata(curdata, &Pr)) != OK)
	    return(r);
	break;

    default:
	return(NOTOK);
    }

    /* CHECK THAT MODULUS LENGTH IS WITHIN IMPLEMENTATION RANGE */
    if (Pr.bits < MIN_RSA_MODULUS_BITS || Pr.bits > MAX_RSA_MODULUS_BITS) 
        return(NOTOK);

    /* DECIPHER THE INPUT DATA */
    r = RSAPrivateDecrypt(tmp, &tmplen, in->data, (unsigned)in->length, &Pr);
    if (r != 0) 
	return(NOTOK);

    /* ALLOCATE OUTPUT BBUF */
    if ((*out = alloc_bbuf()) == NULLBB)
	return(NOTOK);
    (*out)->length = tmplen;
    if (((*out) -> data = alloc_uchar((*out) -> length)) == NULLUCP) {
	FREE_BBUF(*out)
	    return(NOTOK);
    }

    /* COPY ENCIPHERED DATA INTO OUTPUT BBUF */
    BCOPY(tmp, (*out)->data, (*out)->length);

    return(OK);
}

/****************************************************************************/
