/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./rsa.h"

int verify_rsa(sig, emicaid)
struct bbuf *sig;
struct bbuf *emicaid;
{
    int r;
    R_RSA_PUBLIC_KEY Pu;
    unsigned char tmp[MAX_RSA_MODULUS_LEN];
    unsigned int tmplen;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (sig == NULLBB || emicaid == NULLBB) 
	return(NOTOK);

    /* PREDECODE RSA KEY DATA */
    if ((r = predecode_rsakeydata(curdata, &curalg)) != OK)
	return(r);

    /* DECODE RSA PUBLIC KEY DATA */
    switch (curalg) {
    case RSA_PUB:
    case RSA_PUB3:
    case RSA_PUBF4:
    case RSAENC_PUB:
    case RSAENC_PUB3:
    case RSAENC_PUBF4:
        if ((r = decode_rsapubkeydata(curdata, &Pu)) != OK)
	    return(r);
	break;

    default:
	return(NOTOK);
    }

    /* CHECK THAT MODULUS LENGTH IS WITHIN IMPLEMENTATION RANGE */
    if (Pu.bits < MIN_RSA_MODULUS_BITS || Pu.bits > MAX_RSA_MODULUS_BITS) 
        return(NOTOK);

    /* DECIPHER THE SIGNATURE */
    r = RSAPublicDecrypt(tmp, &tmplen, sig->data, (unsigned)sig->length, &Pu);
    if (r != 0) 
	return(NOTOK);

    /* COMPARE DECRYPTED EMICAID WITH INPUT EMICAID */
    if (BCMP(emicaid->data, tmp, emicaid->length))
	return(NOTOK);

    return(OK);
}
