/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"
#include "bbuf.h"
#include "util.h"

struct bbuf *trustbb_user(user)
char **user;
{
    struct bbuf *trustbb = NULLBB;
    struct bbuf *tmp = NULLBB;
    struct bbuf bb;
    char **tmpuser = NULLVP;
    char **i, **j;
    char *swap;
    int cmp;

    /* Make sure we have a user */

    if (user == NULLVP) return(NULLBB);

    /* Make a copy of user so we can sort it without affecting the original */

    for (i = user; *i != NULLCP; i++)
	tmpuser = add2av(tmpuser, add2cp(NULLCP, *i));

    /* sort the user record */

    for (i = tmpuser; *i != NULLCP && *(i+1) != NULLCP; i += 2)
	for (j = i+2; *j != NULLCP && *(j+1) != NULLCP; j += 2) {
	    cmp = strcasecmp (*i, *j);
	    if (cmp > 0 || (cmp == 0 && strcasecmp (*(i+1), *(j+1)) > 0)) {
		swap = *i;
		*i = *j;
		*j = swap;
		swap = *(i+1);
		*(i+1) = *(j+1);
		*(j+1) = swap;
		
	    }
	}

    /* Add all tag/value pairs except for "trusted" and "crl" to the bbuf */

    for (i = tmpuser; *i != NULLCP && *(i+1) != NULLCP; i+= 2) 
	if (strcasecmp(*i, "trusted") != 0 && strcasecmp(*i, "crl") != 0) {
	    bb.data = (unsigned char *) *i;
	    bb.length = strlen(bb.data) + 1;
	    tmp = bbufcat (trustbb, &bb);
	    FREE_BBUF(trustbb);
	    trustbb = tmp;
	    bb.data = (unsigned char *) *(i+1);
	    bb.length = strlen(bb.data) + 1;
	    tmp = bbufcat (trustbb, &bb);
	    FREE_BBUF(trustbb);
	    trustbb = tmp;
	}
    
    FREE_AV(tmpuser);
    return trustbb;
}
