/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 *  bdecode.c
 ****************************************************************************/

#include <stdio.h>
#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "util.h"

unsigned char rev_table[256] = {
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,   62,  255,  255,  255,   63,
	  52,   53,   54,   55,   56,   57,   58,   59,
	  60,   61,  255,  255,  255,  255,  255,  255,
	 255,    0,    1,    2,    3,    4,    5,    6,
	   7,    8,    9,   10,   11,   12,   13,   14,
	  15,   16,   17,   18,   19,   20,   21,   22,
	  23,   24,   25,  255,  255,  255,  255,  255,
	 255,   26,   27,   28,   29,   30,   31,   32,
	  33,   34,   35,   36,   37,   38,   39,   40,
	  41,   42,   43,   44,   45,   46,   47,   48,
	  49,   50,   51,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255};

#define octet_one(p)	(((p)[0] << 2) | (((p)[1] >> 4) & 0x3))
#define octet_two(p)	((((p)[1] << 4) & 0xf0) | (((p)[2] >> 2) & 0xf))
#define octet_three(p)	(((((p)[2]) & 0x3) << 6) | ((p)[3]))

bdecode(bin,bout)
struct bbuf *bin;
struct bbuf **bout;
{
    int length, si, di;
    unsigned char buf[4];

    /* DOUBLE CHECK PARAMETERS */
    if (bin == NULLBB || bout == (struct bbuf **)0)
	return(NOTOK);

    FREE_BBUF(*bout);

    /* CHECK FOR ZERO LENGTH INPUT BUFFER */
    if (bin->length == 0) 
	return(OK);

    /* CHECK THAT INPUT BUFFER LENGTH IS MULTIPLE OF 4 */
    if (bin->length % 4 != 0) 
	return(NOTOK);

    /* ALLOCATE OUTPUT BUFFER OF APPROPRIATE LENGTH */
    *bout = alloc_bbuf();
    length = (bin->length * 3) / 4;
    if (bin->data[bin->length-1] == '=') length--;
    if (bin->data[bin->length-2] == '=') length--;
    if (length)
	(*bout)->data = alloc_uchar(length);
    (*bout)->length = length;

    /* DECODE ALL BUT LAST 4 BYTES */
    for (di = si = 0; si<bin->length - 4; si+=4, di+=3) {
	buf[0] = rev_table[bin->data[si]];
	buf[1] = rev_table[bin->data[si+1]];
	buf[2] = rev_table[bin->data[si+2]];
	buf[3] = rev_table[bin->data[si+3]];
	(*bout)->data[di] = octet_one(buf);
	(*bout)->data[di+1] = octet_two(buf);
	(*bout)->data[di+2] = octet_three(buf);
    }

    /* DECODE THE LAST 4 BYTES */
    buf[0] = rev_table[bin->data[si]];
    buf[1] = rev_table[bin->data[si+1]];
    buf[2] = rev_table[bin->data[si+2]];
    buf[3] = rev_table[bin->data[si+3]];
    (*bout)->data[di] = octet_one(buf);
    if (bin->data[si+2] != '=') {
	(*bout)->data[di+1] = octet_two(buf);
	if (bin->data[si+3] != '=') {
	    (*bout)->data[di+2] = octet_three(buf);
	}
    }

    return(OK);
}

/****************************************************************************/
