/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include <stdio.h>

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "util.h"

unsigned char code_table[64] = {
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
	'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
	'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
	'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
	'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
	'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
	'w', 'x', 'y', 'z', '0', '1', '2', '3',
	'4', '5', '6', '7', '8', '9', '+', '/'
};

#define sextet_one(p)	((((p)[0]) >> 2) & 0x3f)
#define sextet_two(p)	(((((p)[0]) & 0x3) << 4) | ((((p)[1]) & 0xf0) >> 4))
#define sextet_three(p)	(((((p)[1]) & 0xf) << 2) | ((((p)[2]) >> 6) & 0x3))
#define sextet_four(p)	(((p)[2]) & 0x3f)

bencode(bin,bout)
struct bbuf *bin;
struct bbuf **bout;
{
    int length, si, di; 

    /* DOUBLE-CHECK PARAMETERS */
    if (bin == NULLBB)
	return(NOTOK);
	
    if (bout == (struct bbuf **)0)
	return(NOTOK);

    FREE_BBUF(*bout);

    /* CHECK FOR ZERO LENGTH INPUT BUFFER */
    if (bin->length == 0)
	return(OK);

    /* ALLOCATE OUTPUT BUFFER OF APPROPRIATE LENGTH */
    *bout = alloc_bbuf();
    length = ((bin->length - 1) / 3 + 1) * 4;
    (*bout)->data = alloc_uchar(length+1); /* leave a NULLC */
    (*bout)->length = length;

    /* ENCODE ALL BUT LAST 1-3 BYTES */
    for (di = si = 0; si<(bin->length)-3; si+=3, di+=4) {
	(*bout)->data[di] = code_table[sextet_one(&(bin->data[si]))];
	(*bout)->data[di+1] = code_table[sextet_two(&(bin->data[si]))];
	(*bout)->data[di+2] = code_table[sextet_three(&(bin->data[si]))];
	(*bout)->data[di+3] = code_table[sextet_four(&(bin->data[si]))];
    }

    /* ENCODE LAST 1-3 BYTES */
    switch (bin->length-si) {
    case 1:
	(*bout)->data[di] = code_table[sextet_one(&(bin->data[si]))];
	(*bout)->data[di+1] = code_table[sextet_two(&(bin->data[si]))&0x30];
	(*bout)->data[di+2] = '=';
	(*bout)->data[di+3] = '=';
	break;

    case 2:
	(*bout)->data[di] = code_table[sextet_one(&(bin->data[si]))];
	(*bout)->data[di+1] = code_table[sextet_two(&(bin->data[si]))];
	(*bout)->data[di+2]=code_table[sextet_three(&(bin->data[si]))&0x3c];
	(*bout)->data[di+3] = '=';
	break;

    case 3:
	(*bout)->data[di] = code_table[sextet_one(&(bin->data[si]))];
	(*bout)->data[di+1] = code_table[sextet_two(&(bin->data[si]))];
	(*bout)->data[di+2] = code_table[sextet_three(&(bin->data[si]))];
	(*bout)->data[di+3] = code_table[sextet_four(&(bin->data[si]))];
	break;

    default:
	/* invalid length */
	return(NOTOK);
    }

    return(OK);
}
