/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include <stdio.h>

#define BYTE unsigned char

main(argc,argv)
int argc;
char **argv;
{
	FILE *fp, *fopen();

	if (argc < 2) fp = stdin;
	else if (argc > 2) {
	    fprintf(stderr, "usage: %s [<filename>]\n", argv[0]);
	    exit(1);
	} else if ((fp = fopen(argv[1],"r")) == NULL) {
	    fprintf(stderr,"can't open %s\n", argv[1]);
	    exit(1);
	}
	_decode(fp,stdout);
	exit(0);
}

static _decode(fi,fo)
FILE *fi;
FILE *fo;
{
	int i, n, j;
	int cc;
	char in[4];
	BYTE out[3];

	n = 0;
	while ((cc = fgetc(fi)) != EOF) {
	    if (isspace(cc)) continue;
	    in[n++] = (char) cc;
	    if (n == 4) {
		j = _decode_aux(in, out);
		for (i=0; i<j; i++) fputc(out[i], fo);
		n = 0;
	    }
	}
	if (n) {
	    fprintf(stderr, "input length not multiple of 4; ");
	    fprintf(stderr, "ignoring extra characters\n");
	}
}

static int _decode_aux(in,out)
char *in;
BYTE *out;
{
	int i, j;
	int n, x;
	BYTE bin[24];

	for (i=0; i<4; i++) {
	    if (in[i] == '=') break;
	    x = invtable(in[i]);
	    for (j=0; j<6; j++) bin[i*6+j] = (x >> (5-j)) & 1;
	}
	n = i - 1;
	for (i=0; i<n; i++) {
	    x = 0;
	    for (j=0; j<8; j++) x = (x << 1) + bin[i*8+j];
	    out[i] = x;
	}
	return(n);
}

int invtable(c)
char c;
{
	if      (c>='A' && c<='Z') return(c-65);	/* A-Z */
	else if (c>='a' && c<='z') return(c-71);	/* a-z */
	else if (c>='0' && c<='9') return(c+4);		/* 0-9 */
	else if (c=='+') return(62);			/* + */
	else if (c=='/') return(63);			/* / */
	else {
	    fprintf(stderr,"table: character out of range (%d)\n", c);
	    return(-1);
	}
}
