/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include <stdio.h>

#define BYTE unsigned char

main(argc,argv)
int argc;
char **argv;
{
	FILE *fp, *fopen();

	if (argc < 2) fp = stdin;
	else if (argc > 2) {
	    fprintf(stderr, "usage: %s [<filename>]\n", argv[0]);
	    exit(1);
	} else if ((fp = fopen(argv[1],"r")) == NULL) {
	    fprintf(stderr,"can't open %s\n", argv[1]);
	    exit(1);
	}
	_encode(fp,stdout);
	exit(0);
}

static _encode(fi,fo)
FILE *fi;	/* input file pointer */
FILE *fo;	/* output file pointer */
{
	int i, j, n, cc;
	BYTE in[3];
	char out[4];

	n = 0; i = 0;
	while ((cc = fgetc(fi)) != EOF) {
	    in[n++] = cc;
	    if (n == 3) {
		_encode2(in,out,n);
		for (j=0; j<4; j++) fputc(out[j],fo);
		i++;
		if (i == 16) {
		    fputc('\n',fo);
		    i = 0;
		}
		n = 0;
	    }
	}
	if (n != 0) {
	    _encode2(in,out,n);
	    for (j=0; j<4; j++) fputc(out[j],fo);
	    i++;
	    if (i == 16) {
		fputc('\n',fo);
		i = 0;
	    }
	}
	if (i != 0) fputc('\n',fo);
}

static _encode2(in,out,n)
BYTE *in;
char *out;
int n;
{
	int i, j;
	BYTE x;
	BYTE bin[24];
	char table();

	for (i=0; i<n; i++) {
	    x = in[i];
	    for (j=0; j<8; j++) bin[i*8+j] = (x >> (7-j)) & 1;
	}
	for (j=0; j<(3-n)*2; j++) bin[i*8+j] = 0;
	for (i=0; i<n+1; i++) {
	    x = 0;
	    for (j=0; j<6; j++) x = (x << 1) + bin[i*6+j];
	    out[i] = table(x);
	}
	for (i=n+1; i<4; i++) out[i] = '=';
}

static char table(x)
int x;
{
	if (x>=0 && x<=25) return(x+65);		/* A-Z */
	else if (x>=26 && x<=51) return(x+71);		/* a-z */
	else if (x>=52 && x<=61) return(x-4);		/* 0-9 */
	else if (x==62) return('+');			/* + */
	else if (x==63) return('/');			/* / */
	else {
	    fprintf(stderr,"table: value out of range (%d)\n", x);
	    return('?');
	}
}
