#include <stdio.h>
#include <string.h>
#include <idea.h>
#include "libpgp2.h"

/*------------------------------------*/
/* conventional decryption from packet */
int cnvdec2(FILE * inf, FILE * outf, unsigned char *passwdhash)
{
  int len;
  unsigned char dbuf[4096];
  unsigned char ivec[8];
  IDEA_KEY_SCHEDULE iks;
  int ivc;

  skip2ctb(inf, 0xa4, 0xfc);
  ivc = 0;
  idea_set_encrypt_key(passwdhash, &iks);
  memset(ivec, 0, 8);
  fread(dbuf, 10, 1, inf);
  memcpy(&dbuf[20], &dbuf[2], 8);
  idea_cfb64_encrypt(dbuf, dbuf, 10, &iks, ivec, &ivc, IDEA_DECRYPT);
  if (dbuf[8] != dbuf[6] || dbuf[9] != dbuf[7])
    return -1;
  ivc = 0;
  memcpy(ivec, &dbuf[20], 8);
  do {
    if ((len = fread(dbuf, 1, 4096, inf)))
      idea_cfb64_encrypt(dbuf, dbuf, len, &iks, ivec, &ivc, IDEA_DECRYPT);
    fwrite(dbuf, 1, len, outf);
  } while (len == 4096);
  return 0;
}
