#!/bin/sh
export PGPPATH=.

echo ========== Generating key:
#needs existing pubring.pkr with good parameters in the first key.
#I could use newkeygen, but it takes a while...

./new5key -K 0 -k 0 -r pubring.pkr -u "Test Key" #-p testpass
#this probably should be a cat, but...
mv pubnew.pkr pubring.pkr
mv secnew.skr secring.skr

#fix pubring to allow crypyption
./lookup5 -x -m Test | ./pgp5sign -t 24 -p testpass >>pubring.pkr
echo -ne "\260\001\147" >>pubring.pkr
#strictly, you also need to use pgpk -s to sign the DSS key on the pubring

pgpk -l

echo ========== encrypt test

cat new5key | ./pgp5cryp -l rdx | ../minipgp/minipgp -z | ./pgp5cryp | \
  ./pgp5cryp -k 0 >rdx.enc

rm -f rdx
pgpv rdx.enc
if cmp rdx new5key; then echo quick encrypt ok; else exit 0; fi
rm rdx

echo ========== encrypt and One pass sig test

for siga in 16 ; do
    for hash in 1 2; do
        for alg in 1 2 3; do
            echo testing enc $alg, hash $hash, sig $siga
            cat new5key | ./pgp5cryp -l rdx >rdx.one
            ./pgp5sign -A $siga -a $hash -t 1 -p testpass -1 >rdx.pre
            ./pgp5sign -A $siga -a $hash -t 1 -p testpass <new5key >rdx.two
            cat rdx.pre rdx.one rdx.two | ../minipgp/minipgp -z | \
              ./pgp5cryp | ./pgp5cryp -k 0 -a $alg >rdx.enc
            rm -f rdx rdx.pre rdx.one rdx.two
            pgpv rdx.enc -o rdx

            if cmp rdx new5key ; then echo pgp decrypt ok; else exit 0; fi
            ./pgp5cryp -d <rdx.enc -p testpass | ./pgp5sign -v | \
              ../minipgp/minipgp | ./pgp5sign -v >rdy.out
            if cmp rdy.out new5key ; then echo our decrypt ok; else exit 0; fi
        done
    done
done
rm rdx rdy.out

echo ========== decrypt test

rm -f rdx.out
pgpe new5key -r Test -s -u Test -o rdx.out
./pgp5cryp -d <rdx.out -p testpass | ./pgp5sign -v | ../minipgp/minipgp |\
  ./pgp5sign -v >rdy.out
if cmp rdy.out new5key; then echo our decrypt ok; else exit 0; fi
rm rdy.out

echo ========== Detached Signature test

for siga in 16; do
for hash in 1 2; do
    ./pgp5sign <pgp5cryp >pgp5cryp.sig -p testpass -a $hash -A $siga
    ./pgp5sign -v <pgp5cryp -s pgp5cryp.sig
    pgpv pgp5cryp.sig
done
done

rm pgp5cryp.sig
