#include <stdio.h>
#include <time.h>

/*-------------------------*/
/* create literal packet */
int enlit(FILE * inf, FILE * outf, unsigned char *fname, int text)
{
  unsigned long fmark, len, ch;
  unsigned char dbuf[4096];

  fputc(0xae, outf);
  fmark = ftell(outf);
  fwrite(dbuf, 1, 4, outf);     /* save space */
  fputc(text ? 't' : 'b', outf);
  ch = strlen(fname);           /* filename (null terminated) in fname */
  fputc(ch, outf);
  fwrite(fname, 1, ch, outf);
  len = time(NULL);             /* this should be zero, or modtime */
  fputc(len >> 24, outf);
  fputc(len >> 16, outf);
  fputc(len >> 8, outf);
  fputc(len, outf);
  ch += 6;
  do {
    if ((len = fread(dbuf, 1, 4096, inf)))
      ch += len,
        fwrite(dbuf, 1, len, outf);
  } while (len == 4096);
  fseek(outf, fmark, SEEK_SET);
  fputc(ch >> 24, outf);
  fputc(ch >> 16, outf);
  fputc(ch >> 8, outf);
  fputc(ch, outf);
  return 0;
}
