/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: /usr/home/rick/fwtk/crypt/RCS/cliio.c,v 1.2 1996/09/05 15:57:54 rick Exp $";

/* THIS CODE NOT FOR EXPORT */

#include	<stdio.h>
#include	<syslog.h>
#include	<sys/signal.h>

#include	"firewall.h"
#include	"auth.h"

#include	"des.h"


/* #define	DEBUG */
static	int	rem_authfd = -1;

/* encryption related values */
des_key_schedule	keysched;
des_cblock		cblock;
int			encrypt = 0;


auth_open(confp)
Cfg	*confp;
{
	int	authport = AUTH_DEFAULTPORT;
	char	*authserver = AUTH_DEFAULTSERVER;
	Cfg	*cf;

	if(rem_authfd != -1)
		return(0);

	if((cf = cfg_get("authserver",confp)) != (Cfg *)0) {
		if(cf->argc < 1) {
			syslog(LLEV,"fwtkcfgerr: authserver not provided, line %d",cf->ln);
			return(1);
		}
		authserver = cf->argv[0];
		if(cf->argc > 1) {
			authport = atoi(cf->argv[1]);
			if(authport <= 0) {
				syslog(LLEV,"fwtkcfgerr: invalid authport %s, line %d",cf->argv[1],cf->ln);
				return(1);
			}
		}
		if(!encrypt && (cf->argc > 2) {
			encrypt = 1;
			des_string_to_key(cf->argv[2],cblock);
			bzero(cf->argv[2],strlen(cf->argv[2]));
			des_set_key(cblock,keysched);
		}
	}


	if(authserver == (char *)0) {
		syslog(LLEV,"fwtkcfgerr: no authserver defined! cannot authenticate!");
		return(1);
	}
	if(authport == -1) {
		syslog(LLEV,"fwtkcfgerr: no authport defined! cannot authenticate!");
		return(1);
	}

	rem_authfd = conn_server(authserver,authport,0,(char *)0);
	if(rem_authfd < 0)
		return(-1);
	signal(SIGPIPE,SIG_IGN);
	return(0);
}




auth_close()
{
	if(rem_authfd != -1)
		close(rem_authfd);
	rem_authfd = -1;
	return(0);
}



static	char	tab[] = "0123456789ABCDEF";

static	void
auth_encode(src,dst,len)
unsigned char	*src;
char		*dst;
int		len;
{
	int	x;
	char	*op = dst;

	for(x = 0; x < len; x++) {
		*op++ = tab[src[x] >> 4];
		*op++ = tab[src[x] & 0x0F];
	}
	*op = '\0';
}


/* am too tired tonight to think of a better way */
static	void
auth_decode(src,dst,len)
char		*src;
unsigned char	*dst;
int		len;
{
	int		x;
	unsigned char	*op = dst;
	char		*s = src;

	for(x = 0; x < len; x++) {
		if(x % 2) {
			if(*s >= 'A' && *s <= 'F')
				*op++ += *s - 'A' + 10;
			else
				*op++ += *s - '0';
		} else {
			if(*s >= 'A' && *s <= 'F')
				*op = (*s - 'A' + 10) * 16;
			else
				*op = (*s - '0') * 16;
		}
		s++;
	}
	*op = '\0';
}


auth_send(buf)
char	*buf;
{
	int	x;
	char	cbuf[4098];
	char	ebuf[4098];
	char	*bp = buf;


	if(rem_authfd < 0)
		return(1);

	if(encrypt) {
		char			iv[8];
		des_key_schedule	ks;

		bzero(iv,sizeof(iv));
		bcopy(keysched,ks,sizeof(des_key_schedule));
		if((x = strlen(bp) + 1) % 8)
			x = x + (8 - (x % 8));
		if(x * 2 > sizeof(cbuf))
			return(1);
		des_cbc_encrypt(buf,cbuf,x,ks,iv,DES_ENCRYPT);
		auth_encode(cbuf,ebuf,x);
		bp = ebuf;
	}
#ifdef	DEBUG
	syslog(LLEV,"auth_send %s\n",bp);
#endif
	x = strlen(bp);
	if(write(rem_authfd,bp,x) != x || write(rem_authfd,"\n",1) != 1)
		return(1);
	return(0);
}


auth_recv(buf,siz)
char	*buf;
int	siz;
{
	int	x = 0;
	char	ibuf[4096];
	char	ebuf[4096];
	int	isiz = siz;
	char	*bp = buf;

	if(rem_authfd < 0)
		return(1);

	if(encrypt) {
		bp = ibuf;
		isiz = sizeof(ibuf);
	}

	while(1) {
		if(x + 1 == isiz) {
			syslog(LLEV,"fwtksyserr: auth_rmtrecv: buffer overflow");
			return(1);
		}
		if(read(rem_authfd,&bp[x],1) != 1) {
			syslog(LLEV,"fwtksyserr: auth_rmtrecv: read error: %m");
			return(1);
		}
		if(bp[x] == '\n')
			break;
		x++;
	}
	bp[x] = '\0';

	/* now decrypt */
	if(encrypt) {
		char			iv[8];
		des_key_schedule	ks;

		auth_decode(ibuf,ebuf,x);
		bzero(iv,sizeof(iv));
		bcopy(keysched,ks,sizeof(des_key_schedule));
		des_cbc_encrypt(ebuf,ibuf,x/2,ks,iv,DES_DECRYPT);
		strcpy(buf,ibuf);
	}
#ifdef	DEBUG
	syslog(LLEV,"auth_recv %s\n",buf);
#endif
	return(0);
}




auth_perm(confp, name, oper, dest, op)
Cfg	*confp;
char	*name;
char	*oper;
char	*dest;
char	*op;
{

	char	sbuf[512];
	int	hadtoopen = 0;

	/* Check to see if the auth database needs to be opened */
	if(rem_authfd < 0) {
		if(auth_open(confp)) {
			return(1);
		}
		hadtoopen = 1;
		if(auth_recv(sbuf,sizeof(sbuf)))
			goto lostconn;
		if(strncmp(sbuf,"Authsrv ready",13)) {
			auth_close();
			return(1);
		}
	}


	/*
	Build the string for authsrv resultant string should look like:
	operation user smith telnet-gw relay.tis.com
	*/
	sbuf[0] = '\0';

	if(op == (char *)0)
		sprintf(sbuf,"operation user %s %s %s", name,oper,dest);
	else
		sprintf(sbuf,"operation user %s %s %s",name,oper,dest,op);

	if(auth_send(sbuf))
		goto lostconn;

	if(auth_recv(sbuf,sizeof(sbuf)))
		goto lostconn;

	if(!strncmp(sbuf,"ok ",3))
		return(0);

	if(!strncmp(sbuf,"Perm",4))
		return(1);
	return(-1);

lostconn:
	if(hadtoopen)
		auth_close();
	return(-1);
}
