/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: snk.c,v 1.3 93/11/12 09:51:58 mjr rel $";

#include	<ctype.h>

#include	"firewall.h"
#include	"auth.h"

#ifdef	AUTHPROTO_SNK
#include	"des.h"

extern	long	randomnumber();

static	int	challenged = 0;
static	char	challbuf[32];


snkchallng(user,buf,bs)
char	*user;
char	*buf;
int	bs;
{
	challenged = 1;
	strcpy(buf,"SNK Challenge \"");
	sprintf(challbuf,"%6.6lu",randomnumber() % 999999);
	strcat(buf,challbuf);
	strcat(buf,"\": ");
	return(0);
}


/* is this ugly or what? it's late and I don't feel clever */
static	int
make_key_sched(s,k)
char		*s;
des_cblock	k;
{
	int	k0;
	int	k1;
	int	k2;
	int	k3;
	int	k4;
	int	k5;
	int	k6;
	int	k7;
	int	x;

	x = sscanf(s, "%o %o %o %o %o %o %o %o",
		&k0, &k1, &k2, &k3, &k4, &k5, &k6, &k7);
	if(x != 8)
		return(1);
	k[0] = k0;
	k[1] = k1;
	k[2] = k2;
	k[3] = k3;
	k[4] = k4;
	k[5] = k5;
	k[6] = k6;
	k[7] = k7;
	return(0);
}



snkverify(user,pass,ap,rbuf)
char	*user;
char	*pass;
Auth	*ap;
char	*rbuf;
{
	des_key_schedule	keysched;
	des_cblock		kblock;
	char			buf[12];
	char			cbuf[12];
	int			i;
	int			j;
	unsigned long		kval = 0;

	strcpy(rbuf,"Permission Denied.");
	if(!challenged)
		return(1);
	challenged = 0;

	/* lowercase the response code, in case it's hex */
	for(i=0; pass[i]; i++)
		if(isupper(pass[i]))
			pass[i] = tolower(pass[i]);

	/* set up a key from the shared secret */
	if(make_key_sched(ap->pw,kblock)) {
		strcpy(rbuf,"Cannot decode user secret key");
		return(1);
	}
	des_set_key(kblock,keysched);

	/* zeroize the entire buffer */
	for(i = 0; i < 9; i++)
		buf[i] = '\0';
	strncpy(buf,challbuf,8);

	/* push it through the rotating knives */
	des_ecb_encrypt(buf,cbuf,keysched,DES_ENCRYPT);

	/* pull some bits out of the ciphertext into a long */
	for(i=0; i<4; i++)
		for(j = 0; j < 8; j++)
			kval = (kval << 1) | ((cbuf[i] >> (7 - j)) & 1);

	/* crunch it into a hex string */
	sprintf(buf,"%08x",kval);
	if(!strcmp(pass,buf)) {
		strcpy(rbuf,"ok");
		return(0);
	}

	/* crunch hex to decimal and try that */
	for(i=0; buf[i]; i++)
		if(buf[i] == 'a' || buf[i] == 'b' || buf[i] == 'c')
			buf[i] = '2';
		else
			if(buf[i] == 'd' || buf[i] == 'e' || buf[i] == 'f')
				buf[i] = '3';
	if(strcmp(pass,buf))
		return(1);
	strcpy(rbuf,"ok");
	return(0);
}


snkset(user,pass,ap,rbuf)
char	*user;
char	*pass;
Auth	*ap;
char	*rbuf;
{
	des_cblock		kblock;

	if(make_key_sched(pass,kblock)) {
		strcpy(rbuf,"Cannot decode user secret key");
		return(0);
	}
	if(strlen(pass) >= AUTH_PWSIZ) {
		strcpy(rbuf,"Secret key too long");
		return(0);
	}
	strcpy(ap->pw,pass);
	if(auth_dbputu(user,ap) == 0)
		strcpy(rbuf,"Secret key changed");
	else
		strcpy(rbuf,"Database error.");
	return(0);
}
#endif
