/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: srvio.c,v 1.3 94/05/27 14:11:42 mjr rel $";

/* THIS CODE NOT FOR EXPORT */

#include	<stdio.h>
#include	<syslog.h>
#include	<sys/signal.h>

#include	"firewall.h"
#include	"auth.h"

#include	"des.h"


/* #define	DEBUG */



/* encryption related values */
des_key_schedule	keysched;
des_cblock		cblock;
int			encrypt = 0;


srvsayinit(confp,rl,ri)
Cfg	*confp;
char	*rl;
char	*ri;
{
	Cfg	*cf;

	cf = cfg_get("hosts",confp);
	while(cf != (Cfg *)0) {
		if(cf->argc < 1)
			goto skip;

		if(hostmatch(cf->argv[0],ri)) {
			if(cf->flags & PERM_DENY)
				goto deny;
			if(cf->argc > 1) {
				encrypt = 1;
				des_string_to_key(cf->argv[1],cblock);
				bzero(cf->argv[1],strlen(cf->argv[1]));
				des_set_key(cblock,keysched);
			}
			return(0);
		}
skip:
		cf = cfg_get("hosts",(Cfg*)0);
	}
deny:
	syslog(LLEV,"deny host=%s/%s",rl,ri);
	return(1);
}




static	char	tab[] = "0123456789ABCDEF";

static	void
auth_encode(src,dst,len)
unsigned char	*src;
char		*dst;
int		len;
{
	int	x;
	char	*op = dst;

	for(x = 0; x < len; x++) {
		*op++ = tab[src[x] >> 4];
		*op++ = tab[src[x] & 0x0F];
	}
	*op = '\0';
}


/* am too tired tonight to think of a better way */
static	void
auth_decode(src,dst,len)
char		*src;
unsigned char	*dst;
int		len;
{
	int		x;
	unsigned char	*op = dst;
	char		*s = src;

	for(x = 0; x < len; x++) {
		if(x % 2) {
			if(*s >= 'A' && *s <= 'F')
				*op++ += *s - 'A' + 10;
			else
				*op++ += *s - '0';
		} else {
			if(*s >= 'A' && *s <= 'F')
				*op = (*s - 'A' + 10) * 16;
			else
				*op = (*s - '0') * 16;
		}
		s++;
	}
	*op = '\0';
}


srvsay(buf)
char	*buf;
{
	int	x;
	char	cbuf[4098];
	char	ebuf[4098];
	char	*bp = buf;


	if(encrypt) {
		char			iv[8];
		des_key_schedule	ks;

		bzero(iv,sizeof(iv));
		bcopy(keysched,ks,sizeof(des_key_schedule));
		if((x = strlen(bp) + 1) % 8)
			x = x + (8 - (x % 8));
		if(x * 2 > sizeof(cbuf))
			return(1);
		des_cbc_encrypt(buf,cbuf,x,ks,iv,DES_ENCRYPT);
		auth_encode(cbuf,ebuf,x);
		bp = ebuf;
	}
#ifdef	DEBUG
	syslog(LLEV,"auth_send %s\n",bp);
#endif
	x = strlen(bp);
	if(write(0,bp,x) != x || write(0,"\n",1) != 1)
		return(1);
	return(0);
}


srvhear(buf,siz)
char	*buf;
int	siz;
{
	int	x = 0;
	char	ibuf[4096];
	char	ebuf[4096];
	int	isiz = siz;
	char	*bp = buf;

	if(encrypt) {
		bp = ibuf;
		isiz = sizeof(ibuf);
	}

	while(1) {
		if(x + 1 == isiz) {
			syslog(LLEV,"fwtksyserr: auth_rmtrecv: buffer overflow");
			return(1);
		}
		switch(read(0,&bp[x],1)) {
		case 0:
			return(1);
		case 1:
			break;
		default:
			syslog(LLEV,"fwtksyserr: auth_rmtrecv: read error: %m");
			return(1);
		}
		if(bp[x] == '\n')
			break;
		x++;
	}
	bp[x] = '\0';

	/* now decrypt */
	if(encrypt) {
		char			iv[8];
		des_key_schedule	ks;

		auth_decode(ibuf,ebuf,x);
		bzero(iv,sizeof(iv));
		bcopy(keysched,ks,sizeof(des_key_schedule));
		des_cbc_encrypt(ebuf,ibuf,x/2,ks,iv,DES_DECRYPT);
		strcpy(buf,ibuf);
	}
#ifdef	DEBUG
	syslog(LLEV,"auth_recv %s\n",buf);
#endif
	return(0);
}
