/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 *	fixes for newer securid from Alastair Young <alastair@cadence.com>
 */
static	char	RcsId[] = "$Header: /usr/home/rick/fwtk2.0/fwtk/auth/RCS/securid.c,v 1.4 1996/04/05 17:41:29 rick Exp $";
#include <stdio.h>
#include <syslog.h>
#include <errno.h>
#include <sys/types.h>

#include	"firewall.h"
#include	"auth.h"

#ifdef	AUTHPROTO_SECURID

#include "sdi_athd.h"
#include "sdi_size.h"
#include "sdi_type.h"
#include "sdacmvls.h"
#include "sdconf.h"

union config_record configure;

static	int			challenged = 0;
static	int			sd_initted = 0;
static	struct SD_CLIENT	sdbuf, *sd;
static	int			sd_state = 0;
#define CHALLENGE		0
#define NEW_PIN_CHECK_CHANGE	1
#define NEW_PIN_PROMPT_LINE1	2
#define NEW_PIN_PROMPT_LINE2	3
#define NEW_PIN_PROMPT_LINE3	4
#define NEW_PIN_PROMPT_LINE4	5
#define NEW_PIN_GET_PIN		6
#define NEW_PIN_SET_PIN		7
#define NEW_PIN_RE_ENTER	8
#define NEW_PIN_RE_PROMPT	9
#define	NEXT_CODE		10

secichallng(user,buf,bs)
char	*user;
char	*buf;
int	bs;
{
	char	pinsize[20], pintype[20];

	challenged = 1;
	switch (sd_state) {
	    case CHALLENGE:
		/* Gross hack - back up into the "challenge" prompt */
		buf = buf - 10;
		strcpy(buf,"chalnecho Enter PASSCODE: ");
		break;	
	    case NEXT_CODE:
		strcpy(buf, "chalnecho Enter the next cardcode: ");
		break;	
	    case NEW_PIN_CHECK_CHANGE:
		strcpy(buf, "challenge New PIN required; do you wish to continue? (y/n) [n]: ");
		break;	
	    case NEW_PIN_PROMPT_LINE1:
		if (sd->alphanumeric)
			strcpy(pintype, "characters");
		else
			strcpy(pintype, "digits");
		if (sd->min_pin_len == sd->max_pin_len)
			sprintf(pinsize, "%d", sd->min_pin_len);
		else
			sprintf(pinsize,"%d to %d", sd->min_pin_len, sd->max_pin_len);
		if (sd->user_selectable) {
			sprintf(buf,"display Enter your new PIN, containing %s %s",
				pinsize, pintype);
			break;	
		} else {
			sprintf(buf,"display Press RETURN to generate a new PIN and display it on the screen");
		}
		break;
	    case NEW_PIN_PROMPT_LINE2:
	    case NEW_PIN_PROMPT_LINE4:
		sprintf(buf, "display                      or");
		break;
	    case NEW_PIN_PROMPT_LINE3:
		if (sd->user_selectable) {
			sprintf(buf,"display Press RETURN to generate a new PIN and display it on the screen");
		} else {
			sprintf(buf,"challenge Ctrl d to leave your card in new PIN mode: ");
			sd_state = NEW_PIN_GET_PIN;
		}
		break;
	    case NEW_PIN_GET_PIN:
		sprintf(buf,"chalnecho Ctrl D to cancel the operation: ");
		break;
	    case NEW_PIN_RE_ENTER:
		strcpy(buf, "chalnecho Please re-enter new PIN: ");
		break;	
	}
	return(0);
}


seciverify(user,pass,ap,rbuf)
char	*user;
char	*pass;
Auth	*ap;
char	*rbuf;
{
	int	result;
	char	debug;
	static  char	newpin[LENPRNST];
	char	*sdhost = NULL;

	strcpy(rbuf,"Permission Denied.");
	if(!challenged)
		return(1);
	if(!sd_initted) {
		bzero(&sdbuf,sizeof(sdbuf));
		creadcfg(); 
		if(tis_sd_init(&sdbuf)) {
			strcpy(rbuf,"Cannot talk to ACE server");
			return(1);
		}	
		sd = &sdbuf;
		sd_initted = 1;
	}
	
	switch (sd_state) {
		case CHALLENGE:
			result = sd_check(pass,user,&sdbuf);
			break;
		case NEW_PIN_CHECK_CHANGE:
			if (pass[0] == 'y' || pass[0] == 'Y') {
				sd_state = NEW_PIN_PROMPT_LINE1;
				secichallng(user,rbuf,0);
				return(2);
			} else {
				sd_pin("",1,sd);
				return(1);
			}
			break;
		case NEW_PIN_RE_PROMPT:
			sd_state = NEW_PIN_PROMPT_LINE1 - 1;
		case NEW_PIN_PROMPT_LINE1:
		case NEW_PIN_PROMPT_LINE2:
		case NEW_PIN_PROMPT_LINE3:
		case NEW_PIN_PROMPT_LINE4:
			sd_state++;
			secichallng(user,rbuf,0);
			return(2);
		case NEW_PIN_GET_PIN:
			if (strlen(pass) == 0) {
				sd_state = NEW_PIN_SET_PIN;
				strncpy(newpin, sd->system_pin, LENMAXPIN);
				sprintf(rbuf,"display New PIN:    %s",newpin);
				return(2);
			} else {
				sd_state = NEW_PIN_RE_ENTER;
				strncpy(newpin, pass, LENMAXPIN);
				secichallng(user,rbuf,0);
				return(2);
			}
		case NEW_PIN_RE_ENTER:
			if (strlen(pass) == 0) {
				sd_state = NEW_PIN_SET_PIN;
				strncpy(newpin, sd->system_pin, LENMAXPIN);
				sprintf(rbuf,"display New PIN:    %s",newpin);
				return(2);
			} else {
				if (strncmp(newpin, pass, LENMAXPIN) != 0) {
					sprintf(rbuf,"display PIN does not match - retry");
					sd_state = NEW_PIN_RE_PROMPT;
					return(2);
				}
				sd_state = NEW_PIN_SET_PIN;
			}
		case NEW_PIN_SET_PIN:
			result = sd_pin(newpin,0,&sdbuf);
			break;
		case NEXT_CODE:
			result = sd_next(pass,&sdbuf);
			break;
	}

	sd_state = 0;
	switch(result) {
		case ACM_NEW_PIN_ACCEPTED:
			strcpy(rbuf,"Wait for the code on your card to change, then log in with your new PIN");
			return(1);
		case ACM_OK:
			strcpy(rbuf,"ok");
			return(0);
		case ACM_ACCESS_DENIED:
			syslog(LLEV,"access denied");
			return(1);
		case ACM_NEXT_CODE_REQUIRED:
			sd_state = NEXT_CODE;
			secichallng(user,rbuf,0);
			return(2);
		case ACM_NEW_PIN_REQUIRED:
			sd_state = NEW_PIN_CHECK_CHANGE;
			secichallng(user,rbuf,0);
			return(2);
	}
	sd_state = 0;
	/* default. huh? */
	return(1);
}



seciset(user,pass,ap,rbuf)
char	*user;
char	*pass;
Auth	*ap;
char	*rbuf;
{
	int status;
	Cfg	*cfp;
	char	*sdhost = NULL;

	syslog(LLEV,"Changing password for %s to %s",user,pass);
	if(pass == (char *)0) {
		strcpy(rbuf,"NULL PIN not supported with SecurID");
		return(0);
	}
	if(!sd_initted) {
		bzero(&sdbuf,sizeof(sdbuf));
		creadcfg(); 
		if(sd_init(&sdbuf)) {
			strcpy(rbuf,"Cannot talk to ACE server");
			return(1);
		}	
		sd = &sdbuf;
		sd_initted = 1;
	}

	if((status = sd_pin(pass,0,&sdbuf)) != ACM_NEW_PIN_ACCEPTED) {
		strcpy(rbuf,"New PIN Rejected");
		return(1);
	}
	strcpy(rbuf,"New PIN Accepted");
	return(0);
}
#endif
