/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/* part of http-gw
 */

#include "http-gw.h"

#include "ict.h"


struct image_rec{
int	type;
char	**ext;
char	*info;
}image_table[] = {
{ '1',	&APGM,	"<IMG ALT=\"[DIR]\" SRC=\"%smenu.gif\">"},
{ '1',	&APGPM,	"<IMG ALT=\"[DIR]\" SRC=\"%smenuplus.gif\">"},
{ 'h',	NULL,	"<IMG ALT=\"[DIR]\" SRC=\"%shtml.gif\">"},
{ 'g',	&IMGIF,	"<IMG ALT=\"[IMG]\" SRC=\"%sgif.gif\">"},
{ 'j',	&IMJPG,	"<IMG ALT=\"[IMG]\" SRC=\"%sjpeg.gif\">"},
{ 'I',	NULL,	"<IMG ALT=\"[IMG]\" SRC=\"%simage.gif\">"},
{ 's',	NULL,	"<IMG ALT=\"[AU ]\" SRC=\"%saudio.gif\">"},
{ '7',	NULL,	"<IMG ALT=\"[IDX]\" SRC=\"%ssearch.gif\">"},
{ '8',	NULL,	"<IMG ALT=\"[TEL]\" SRC=\"%stelnet.gif\">"},
{ ';',	NULL,	"<IMG ALT=\"[BIN]\" SRC=\"%svideo.gif\">"},
{ '2',	NULL,	"<IMG ALT=\"[BIN]\" SRC=\"%scso.gif\">"},
{ '4',	NULL,	"<IMG ALT=\"[BIN]\" SRC=\"%smacbin.gif\">"},
{ '5',	NULL,	"<IMG ALT=\"[BIN]\" SRC=\"%sdosbin.gif\">"},
{ '9',	NULL,	"<IMG ALT=\"[BIN]\" SRC=\"%sbinary.gif\">"},
{ '0',	NULL,	"<IMG ALT=\"[TXT]\" SRC=\"%stext.gif\">"},
{ 0,	NULL,	"<IMG ALT=\"[TXT]\" SRC=\"%sblank.gif\">"}
};


char imagenamebuf[MAX_URL_LEN];

char *image_for(typech, ext)
int typech;
char *ext;
{	char *res = NULL;
	struct image_rec *t = image_table;
	char extbuf[80];
	char *iconurl = NULL;

	if( typech == 0 && ext != NULL){
		if( !strncasecmp(ext, "image/", 6))
			typech = 'I';
		else if( !strncasecmp(ext, "audio/", 6))
			typech = 's';
	}

	if( typech == 0 || typech == ' '){
		typech = '0';
	}

	while(t->type){
		if( typech == t->type)
			break;
		if( ext && t->ext){
			if( !strcasecmp(ext, *t->ext)){
				break;
			}
		}
		t++;
	}
	if( default_icon_url[0] == '\0'){
		sprintf(go_request,"http://%s:%d/-http-gw-internal-/", ourname, ourport);
		iconurl = go_request;
	}else{
		iconurl = default_icon_url;
	}
	sprintf(imagenamebuf, t->info, iconurl);
	return imagenamebuf;
}

char	info[MAX_URL_LEN];
int	info_state;
int	info_typech;
char	*info_parse_vec[7];
int	viewcnt;
char	*views[16];			/* Max 16 different views! */
char	*item_len[16];
int	is_ask_block;


int gopher_start_item(parse_vec, gtypech)
char **parse_vec;
int gtypech;
{	int x;

	for(x=0; x < 7; x++){
		info_parse_vec[x] = parse_vec[x];
	}
	info_typech = gtypech;

	return 0;
}

int gopher_item_add_view(view, len)
char *view;
char *len;
{	
	if( viewcnt < 16){
		views[viewcnt] = makestring(view);
		item_len[viewcnt] = makestring(len);
		viewcnt++;
	}

	return 0;
}


int free_view(x)
int x;
{
	if( views[x])free(views[x]);
	views[x] = NULL;
	if( item_len[x])free(item_len[x]);
	item_len[x] = NULL;
	return 0;
}

int trim_views_list()
{	int x,y,z;
	char *p;

	if( viewcnt == 0)
		return 0;	/* nothing to do */

	if( info_typech == '1'){
/* if only a gopher-menu, fetch in NON-PLUS mode */
		if( viewcnt == 1 && !strcasecmp(APGM, views[0])){
			free_view(0);
			viewcnt = 0;
			return 0;
		}
		
/* if there is a gopher+ menu, keep just it! */
		for(x=0; x < viewcnt; x++){
			if( !strcasecmp(APGPM, views[x])){
				if( x != 0){
					free_view(0);
					views[0] = views[x];
					item_len[0] = item_len[x];
					views[x] = NULL;
					item_len[x] = NULL;
				}
				for(y=1; y < viewcnt; y++){
					free_view(y);
				}
				viewcnt = 1;
				return 0;
			}
		}
	}

	return 0;
}


int flush_gopher_to_html(sockfd)
int sockfd;
{	char 	**parse_vec;
	char 	*img, *ext;
	char	*p;
	int x;

	if( info[0] == '\0' || info_parse_vec[0] == NULL)
		return 0;

	trim_views_list();

	if( viewcnt == 0){
		p = "";
		img = image_for(info_typech, NULL);
		if( img == NULL){
			img = image_for('0', NULL);
		}

		if( info_typech == '1' && info_parse_vec[4]){
			p = "%09$";
		}
		if( is_ask_block){
			p = "%09!";
		}
		sprintf(go_request,"<A HREF=\"%s%s\">", info_parse_vec[1], p);
		say(sockfd, go_request);
		say_sub(sockfd, img);
		say_sub(sockfd, "</A>   ");
	}else{
		for(x = 0; x < viewcnt; x++){
			img = image_for(0, views[x]);
			if( img == NULL){
				img = image_for('0', NULL);
			}
			if( is_ask_block){
				sprintf(go_request,"<A HREF=\"%s%%09!\">", info_parse_vec[1]);
			}else {
				sprintf(go_request,"<A HREF=\"%s%%09+%s\">", info_parse_vec[1], views[x]);
			}
			say(sockfd, go_request);
			say_sub(sockfd, img);
			say_sub(sockfd, "</A>   ");
		}
	}
	say_sub(sockfd,"    ");
	sprintf(go_request," %s ", &info_parse_vec[0][1]);
	say_sub(sockfd, go_request);

	if( viewcnt){
		for(x = 0; x < viewcnt; x++){
			if( item_len[x] && *item_len[x]){
				sprintf(go_request," %s%s", item_len[x], (x != viewcnt-1)?",":"");
			}else {
				sprintf(go_request," ?k%s", (x != viewcnt-1)?",":"");
			}
			say_sub(sockfd, go_request);
		}
	}
	if( is_ask_block){
		say_sub(sockfd," [ASK BLOCK]");
	}
	say(sockfd,"<br>");

	for( x = 0; x < viewcnt; x++){
		free_view(x);
	}
	info_state = 0;
	info[0] = '\0';
	viewcnt = 0;
	views[0] = NULL;
	is_ask_block = 0;
	return 0;
}

int gopher_to_proxyhtml(sockfd, rfd, new_reply, gtypech)
int sockfd, rfd;
char *new_reply;
{	char **parse_vec;
	char *p, *q, *ext;
	int x;
	char *img, *br;

	img = NULL;
	br = "";

	if( !strncasecmp(new_reply,"+info:", 6)){
		flush_gopher_to_html(sockfd);
		p = &new_reply[6];
		while(*p == ' ' || *p == '\t')p++;
		strcpy(info, p);
		parse_vec = reply_parse(info);
		if( parse_vec){
			gopher_start_item( parse_vec, gtypech);
			info_state = 1;
			return 0;
		}
	}

	if( !strcmp(new_reply, ".")){
		return 0;
	}

	switch(info_state){
	case 0:
		flush_gopher_to_html(sockfd);
	
		strcpy(info, new_reply);
		parse_vec = reply_parse(info);
		if( parse_vec == NULL)
			break;

		gopher_start_item( parse_vec, gtypech);

		break;

	case 1:
		if( !strncasecmp(new_reply,"+views:", 7)){
			info_state = 2;
		}
		if( !strncasecmp(new_reply,"+ask:", 5)){
			info_state = 10;
		}
		break;

	case 2:
	case 3:
		if( new_reply[0] == '+'){
			if( !strncasecmp(new_reply,"+ask:", 5)){
				info_state = 10;
				break;
			}
			info_state = 4;
			break;
		}
		q = "";
		p = index(new_reply, ':');
		if( p){
			*p = '\0';
			q = p+1;

			while(*q && *q != '<')q++;
			if( *q ){
				char *q1;

				q++;
				q1 = q;
				while(*q1 && *q1 != '>')q1++;
				if( *q1){
					*q1 = '\0';
				}else {
					q = "";
				}
			}
		}

		p = index(&new_reply[1], ' ');
		if( p)*p = '\0';

		gopher_item_add_view(&new_reply[1], q);
		info_state = 3;
		break;

	case 4:
		if( !strncasecmp(new_reply,"+ask:", 5)){
			info_state = 10;
		}
		break;

	case 10:
		info_state = 11;
		is_ask_block = 1;
/* fall through */
	case 11:
		break;

	default:
		break;
	}
	return 0;
}


int gopher_to_html(sockfd, rfd, new_reply, gtypech)
int sockfd, rfd;
char *new_reply;
{	char **parse_vec;
	char *p;
	static char trans_reply[MAX_URL_LEN];
	static char trans_reply2[MAX_URL_LEN];

	if( rem_type & TYPE_PROXYCLIENT){
		gopher_to_proxyhtml(sockfd, rfd, new_reply, gtypech);
		return 0;
	}

	parse_vec = reply_parse(new_reply);
	if( parse_vec){
		int typech;

		copy_with_escapes(trans_reply2, parse_vec[1], MAX_URL_LEN-1, 0);
		parse_vec[1] = trans_reply2;

		p = parse_vec[4];
		if( p == NULL){
			p = "";
		}else {
			errbuf[0] = '\t';
			strcpy(&errbuf[1], p);
			p = errbuf;
		}
		sprintf(trans_reply, 
			"%s\thttp://%s:%s/%s\t%s\t%d%s", parse_vec[0],
			parse_vec[2], parse_vec[3], 
			parse_vec[1], ourname, ourport, p);
		gopher_to_proxyhtml(sockfd, rfd, trans_reply, gtypech);
	}else{
		gopher_to_proxyhtml(sockfd, rfd, new_reply, gtypech);
	}
	return 0;
}


