/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

#include "http-gw.h"

int add_noproxy(host)
char *host;
{	struct noproxy_rec *rec;

	rec = (struct noproxy_rec *)malloc(sizeof(struct noproxy_rec));

	if( rec == NULL)
		return 1;
Debug((debugf,"ADDNP: %s\n", host))
	rec->host = makestring(host);
	rec->next = noproxy_list;
	noproxy_list = rec;
	return 0;
}


int find_noproxy(host)
char *host;
{	struct noproxy_rec *rec = noproxy_list;

	while(rec != NULL){
		if( hostmatch(rec->host, host)){
			return 1;
		}
		rec = rec->next;
	}
	return 0;
}

/* add a forwarding record to the list. */

int add_forward(path, protocol, host)
char *path, *protocol, *host;
{	struct forward_rec *rec, *rec2;

	rec = (struct forward_rec *)malloc(sizeof(struct forward_rec));

	if( rec == NULL)
		return 1;
	rec->path = makestring(path);
	rec->protocol = NULL;
	if( protocol)
		rec->protocol = makestring(protocol);
	rec->host = makestring(host);
	rec->next = NULL;

	rec2 = forward_list;
	if( rec2 == NULL)
		forward_list = rec;		/* list empty */
	else {
		while(rec2->next != NULL){	/* find last one */
			rec2 = rec2->next;
		}
		rec2->next = rec;		/* attach to end */
	}

	return 0;
}

static int namatch(pattern,string)
char    *pattern;
char    *string;
{
        register char c;

        while(1){
		c = *pattern++;
		if( c == '*'){
                        c = *pattern;
                        while(c == '*')
                                c = *++pattern;
                        if(c == '\0')
                                return(1);
                        /* general case, use recursion */
                        while(*string != '\0') {
/* start with first char after *, saves a call */
                                if(c == *string &&
					namatch(&pattern[1],&string[1]))
                                        return(1);
                                ++string;
                        }
                        return(0);
		}
		if( *string != c)
			return 0;
		if( c == '\0')
			return 1;
		string++;
	}
}


struct forward_rec *find_forward(path)
char *path;
{	struct forward_rec *rec;

	rec = forward_list;
	while(rec){
		if( namatch(rec->path, path)){
			return rec;
		}
		rec = rec->next;
	}
	return NULL;
}

int can_forward(buf)
char *buf;
{	struct forward_rec *rec;
	char *p = rem_path;

	if( *buf != '/'){
		*p++ = '/';
	}

	strncpy(p, buf, MAX_URL_LEN-2);

	rec = find_forward(rem_path);

	if( rec == NULL)
		return 0;

	strcpy(buf, rem_path);
	rem_path[0] = '\0';

	strncpy(rem_server, rec->host, MAXHOSTNAMELEN);

	if( !strcasecmp(rec->protocol, "http")){
		rem_type |= TYPE_HTTPREQ;
		strcpy(forward_host, rem_server);
		forward_port = get_port(forward_host, 80);

	}else if( !strcasecmp(rec->protocol, "ftp")){
		rem_type |= TYPE_FTP;
		parse_ftp_login(rec->host);

		p = ftp_server;
		if( p && (p = index(p, ':'))){
			*p = '\0';
		}
		strcpy(forward_host, ftp_server);
		forward_port = get_port(forward_host, 21);

	}else if( !strcasecmp(rec->protocol, "gopher")){
		add_noproxy(rec->host);
		rem_type |= TYPE_GOPHER;
		strcpy(forward_host, rem_server);
		forward_port = get_port(forward_host, 70);
	}

	return 1;
}


