/*-
 * Copyright (c) 1995, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Rick Murphy, Trusted Information Systems, Inc.
 */
static  char    RcsId[] = "$Header: getp.c,v 1.5 95/12/08 16:11:00 gauntlet Exp $";

#include <unistd.h>
#include <stdio.h>
#include <termios.h>
#include <fcntl.h>
#ifndef sun
#include <sys/ioctl.h>
#endif

#define TTY "/dev/tty"
#ifndef TCGETS
#define TCGETS TIOCGETA
#define TCSETS TIOCSETA
#endif

/* Issue prompt and read reply with echo turned off */
char *getpassword(prompt)
char *prompt;
{
    struct termios ttyb, ttysav;
    char *cp;
    int c;
    FILE *tty;
    static char pbuf[128];

/*
 * Following doesn't work with login-sh
 * so assume stdin
 * 
 *   if ((tty = fdopen(open(TTY,O_RDWR),"r")) == NULL)
 *	tty = stdin;
 *   else
 *	setbuf(tty, (char *) NULL);
 */
    tty = stdin;
    ioctl(fileno(tty), TCGETS, &ttyb);
    ioctl(fileno(tty), TCGETS, &ttysav);

    ttyb.c_lflag &= ~(ECHO|ISIG);
    ioctl(fileno(tty), TCSETS, &ttyb);

    fflush(stdout);
    fprintf(stderr, "%s", prompt);
    fflush(stderr);

    cp = pbuf;
    for (;;) {
	c = getc(tty);
	if(c == '\r' || c == '\n' || c == EOF)
	    break;
	if(cp < &pbuf[127])
	    *cp++ = c;
    }
    *cp = '\0';
    fprintf(stderr,"\r\n");
    fflush(stderr);

    ioctl(fileno(tty), TCSETS, &ttysav);
    if (tty != stdin)
	fclose(tty);

    return(pbuf);
}

