/*
#define BINDDEBUG
/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: /usr/home/rick/fwtk2.0/fwtk/tn-gw/RCS/tn-gw.c,v 1.13 1996/09/06 16:55:44 rick Exp $";


#include	<stdio.h>
#include	<ctype.h>
#include	<syslog.h>
#include	<fcntl.h>
#include	<sys/ioctl.h>
#include	<sys/errno.h>
extern	int	errno;
#include	<sys/signal.h>
#include	<arpa/telnet.h>
#include	<sys/time.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#ifdef SYSV
#include	<sys/sockio.h>
#include	<string.h>
#endif /* SYSV */
#include	<netinet/in.h>
#include	<netdb.h>

#ifndef SYSV
extern	char	*index();
#endif /* SYSV */

#include	"firewall.h"

#ifndef	BSIZ
#define	BSIZ	2048
#endif

#ifndef	TNPORT
#define	TNPORT	23
#endif

static	Cfg			*confp;
static  Cfg			*confx;
static	char			**validests = (char **)0;

static	int			authneeded = 0;
static	int			extendperm = 0;
static	char			authuser[512];
static	int			changeok = 0;
static	int			xgwok = 0;
static	int			welcomedone = 0;

static	int			rfd = -1;	/* fd to remote */
static	char			riaddr[512];
static	char			rladdr[512];
static	char			*xforwarder = (char *)0;
static	char			dest[512];
static	unsigned char		prebuf[BUFSIZ];
static	int			prebufc;
static	int			kludgeraw = 0;

static	time_t			ontime;
static	time_t			offtime;
static	int			inbytcnt = 0;
static	int			outbytcnt = 0;

static	char			*prompt;
static	int			promptlen;

extern	char			*maphostname();

static	void			trap_sigurg();
static	int			raw_telnet();

static	int			cmd_quit();
static	int			cmd_help();
static	int			cmd_connect();
static	int			cmd_passwd();
static	int			cmd_xforward();
static	int			cmd_timeout();

static	int			tn3270 = 1;	/* don't do tn3270 stuff */
static	int			doX;

static	int			echomode = 0;
static	unsigned char 		echorespond = 0;
static	int			initialized = 0;
static	int			sawcr = 0;
static	int			timeout = PROXY_TIMEOUT;
static	char			timed_out_msg[] = "\r\nConnection closed due to inactivity";

typedef	struct	{
	char	*name;
	char	*hmsg;
	int	(*op)();
} TnOp;
static	TnOp	ops[] = {
	"connect",	"   connect hostname [serv/port]",	cmd_connect,
	"telnet",	"   telnet hostname [serv/port]",	cmd_connect,
	"open",		0,					cmd_connect,
	"x-gw",		"   x-gw [hostname/display]",		cmd_xforward,
	"help",		"   help/?",				cmd_help,
	"password",	"   password",				cmd_passwd,
	"timeout",	"   timeout seconds",			cmd_timeout,
	"quit",		"   quit/exit",				cmd_quit,
	"close",	0,					cmd_quit,
	"exit",		0,					cmd_quit,
	"?",		0,					cmd_help,
	0,		0,					0
};


extern void waitwaitwait();

main(argc, argv)
int	argc;
char	**argv;
{
	Cfg		*cf;
	struct timeval	timo;
	fd_set		rdy;
	int		x;
	int		y;
	int		towrite;
	char		opt;
	int		runuid = -1;
	int		rungid = -1;
	char		*clientnull = (char *)0;
	char		xuf[1024];
	char		huf[128];
	char		buf[BSIZ];
	char		tokbuf[BSIZ];
	char		*tokav[56];
	int		tokac;

#ifndef	LOG_DAEMON
	openlog("tn-gw",LOG_PID);
#else
	openlog("tn-gw",LOG_PID|LOG_NDELAY,LFAC);
#endif
	if (argc > 1 && !strcmp(argv[1],"-daemon")) {
		argc--;
		argv++;
		syslog(LLEV,"Starting daemon mode on port 23");
		do_daemon(23);
	}

	time(&ontime);
	strcpy(authuser,"unauth");
	dest[0] = '\0';

	if((confp = cfg_read("tn-gw")) == (Cfg *)-1)
		exit(1);

#ifdef	BINDDEBUG
	/*
	useful for debugging. if you define this it will bind the
	port and listen directly (circumventing inetd) so you can
	run the program under a debugger
	*/
	debugbind();
#endif

	signal(SIGCHLD, waitwaitwait);
	signal(SIGURG,trap_sigurg);
	set_oob_notification(0);

	if(peername(0,rladdr,riaddr,sizeof(riaddr))) {
		syslog(LLEV,"fwtksyserr: cannot get peer name: %m");
		exit(1);
	}


	if((cf = cfg_get("groupid",confp)) != (Cfg *)0) {

		if(cf->argc != 1) {
			syslog(LLEV,"fwtkcfgerr: groupid must have one parameter, line %d",cf->ln);
			exit(1);
		}
		if((rungid = mapgid(cf->argv[0])) == -1) {
			syslog(LLEV,"fwtkcfgerr: cannot map %s to gid",cf->argv[0]);
			exit(1);
		}
	}

	if((cf = cfg_get("userid",confp)) != (Cfg *)0) {

		if(cf->argc != 1) {
			syslog(LLEV,"fwtkcfgerr: userid must have one parameter, line %d",cf->ln);
			exit(1);
		}
		if((runuid = mapuid(cf->argv[0])) == -1) {
			syslog(LLEV,"fwtkcfgerr: cannot map %s to uid",cf->argv[0]);
			exit(1);
		}
	}

	if((cf = cfg_get("xforwarder",confp)) != (Cfg *)0) {

		if(cf->argc != 1) {
			syslog(LLEV,"fwtkcfgerr: xforwarder must have one parameter, line %d",cf->ln);
			exit(1);
		}
		xforwarder = cf->argv[0];
	}


	if((cf = cfg_get("directory",confp)) != (Cfg *)0) {
		if(cf->argc != 1) {
			syslog(LLEV,"fwtkcfgerr: chroot must have one parameter, line %d",cf->ln);
			exit(1);
		}
		chdir("/");
		if(chdir(cf->argv[0])) {
			syslog(LLEV,"fwtksyserr: chdir %s: %m",cf->argv[0]);
			exit(1);
		}
		if(chroot(cf->argv[0])) {
			syslog(LLEV,"fwtksyserr: chroot %s: %m",cf->argv[0]);
			exit(1);
		}
		chdir("/");
	}


	if(rungid != -1 && setgid(rungid)) {
		syslog(LLEV,"fwtksyserr: cannot setgid %d: %m",rungid);
		exit(1);
	}

	if(runuid != -1 && setuid(runuid)) {
		syslog(LLEV,"fwtksyserr: cannot setuid %d: %m",runuid);
		exit(1);
	}


#ifdef	SO_KEEPALIVE
	opt = 1;
	(void)setsockopt(0,SOL_SOCKET,SO_KEEPALIVE,&opt,sizeof(opt));
#endif

	/* see if this is someone we are even willing to converse with */
	if(!oktotalkto()) {
		if((cf = cfg_get("denial-msg",confp)) != (Cfg *)0) {
			if(cf->argc != 1) {
				syslog(LLEV,"fwtkcfgerr: denial-msg must have one parameter, line %d",cf->ln);
				exit(1);
			}
			if(sayfile(0,cf->argv[0])) {
				syslog(LLEV,"fwtksyserr: cannot display denial-msg %s: %m",cf->argv[0]);
				exit(1);
			}
			exit(0);
		} else {
			sprintf(xuf,"%s/%s is not authorized to use the telnet proxy",rladdr,riaddr);
			exit(say(0,xuf));
		}
	}


	if((cf = cfg_get("timeout",confp)) != (Cfg *)0) {
		if(cf->argc != 1) {
			syslog(LLEV,"fwtkcfgerr: timeout must have one parameter, line %d",cf->ln);
			exit(1);
		}
		timeout = atoi(cf->argv[0]);
	}



	/* prompt */
	if((cf = cfg_get("prompt",confp)) != (Cfg *)0) {
		if(cf->argc != 1) {
			syslog(LLEV,"fwtkcfgerr: prompt must have one parameter, line %d",cf->ln);
			exit(1);
		}
		prompt = cf->argv[0];
	} else
		prompt = "tn-gw-> ";
	promptlen = strlen(prompt);

	if (authneeded) {
		if (initialize())
			exit(1);
	/* display a welcome file or message */
		if((cf = cfg_get("welcome-msg",confp)) != (Cfg *)0) {
			if(cf->argc != 1) {
				syslog(LLEV,"fwtkcfgerr: welcome-msg must have one parameter, line %d",cf->ln);
				exit(1);
			}
			if(sayfile(0,cf->argv[0])) {
				syslog(LLEV,"fwtksyserr: cannot display welcome %s: %m",cf->argv[0]);
				exit(1);
			}
			welcomedone = 1;
		}
		if (getauth()) {
			syslog(LLEV,"exit host=%s/%s no auth",rladdr, riaddr);
			exit(1);
		}
	}

	while (argc > 1) {
		argc--;
		argv++;
		if (!strcmp(*argv, "-remhost")) {
			if (argc < 2) {
				syslog(LLEV,"-remhost cmd line argument takes a parameter");
				exit(1);
			}
			argc--;
			argv++;
			strncpy(dest, *argv, 511);
			dest[511] = '\0';
		} else if (!strcmp(*argv,"-startx") || !strcmp(*argv,"-do-x")){
			doX = 1;
		} else {
			syslog(LLEV,"Unknown cmd line argument %s",*argv);
			exit(1);
		}
	}

	if (doX && xforwarder != NULL) {
		sprintf(buf, "x");
		tokac = enargv(buf, tokav, 56, tokbuf, sizeof(tokbuf));

		if (cmd_xforward(tokac, tokav, buf))
			goto leave;
	}

	if (dest[0] != '\0') {
		char *p;

		p = index(dest, ':');
		if (p) {
			*p++ = '\0';
		} else p = "";

		sprintf(buf, "connect %.500s %s",dest, p);
		tokac = enargv(buf, tokav, 56, tokbuf, sizeof(tokbuf));
		if (cmd_connect(tokac, tokav, buf) != 2) {
			goto leave;
		}
	} else {
		if (initialize())
			exit(1);

	/* prompt them until done interacting */
		if (!welcomedone) {
			if((cf = cfg_get("welcome-msg",confp)) != (Cfg *)0) {
				if (cf->argc != 1) {
					syslog(LLEV,"fwtkcfgerr: welcome-msg must have one parameter, line %d",cf->ln);
					exit(1);
				}
				if (sayfile(0,cf->argv[0])) {
					syslog(LLEV,"fwtksyserr: cannot display welcome %s: %m",cf->argv[0]);
					exit(1);
				}
			} else {
				if (gethostname(huf, sizeof(huf)))
					strcpy(huf,"unknown");
				sprintf(xuf, "%s telnet proxy (Version %s) ready:",huf, FWTK_VERSION_MINOR);
				if (say(0, xuf))
					exit(1);
			}
		}
		while((x = usercmd(prompt,promptlen)) == 0)
			;
		if(x == 1) {
			goto leave;
		}

	}

	if (rfd != -1 && prebufc > 0 && write(rfd, prebuf, prebufc) != prebufc)
		goto leave;

	/* main loop */
	while(1) {
		FD_ZERO(&rdy);
		FD_SET(0,&rdy);
		timo.tv_usec = 0;
		timo.tv_sec = timeout;
		errno = 0;
		if(rfd != -1)
			FD_SET(rfd,&rdy);

		x = select(32,&rdy,(fd_set *)0,(fd_set *)0,&timo);
		if (x < 0 && errno != EINTR)
			goto leave;
		if (x < 0)
			continue;
		if(x == 0) {
			syslog(LLEV,"Network timeout signal after %d seconds",timeout);
			(void)say(0, timed_out_msg);
			goto leave;
		}

		if(!kludgeraw && FD_ISSET(0,&rdy)) {
			if(rfd == -1) {
				say(0,"Remote server has closed connection");
				goto leave;
			}
			towrite = read(0,xuf,sizeof(xuf));
			if(towrite <= 0 && errno != EINTR)
				goto leave;

			y = 0;
			if (sawcr && (xuf[0] == '\0' || xuf[0] == '\n')) {
				sawcr = 0;
				y = 1;
			}
			while (y < towrite) {
				if ((x = write(rfd, &xuf[y] ,towrite - y)) < 0 && errno != EINTR) {
					say(0,"Remote server has closed connection");
					goto leave;
				}
				y += x;
			}
			outbytcnt += towrite;
		}


		if(kludgeraw && FD_ISSET(0,&rdy))
			if(raw_telnet())
				goto leave;

		if(rfd != -1 && FD_ISSET(rfd,&rdy)) {
			towrite = read(rfd,xuf,sizeof(xuf));
			if(towrite <= 0 && errno != EINTR) {
				say(0,"Remote server has closed connection");
				goto leave;
			}
			if ((unsigned char)xuf[0] == IAC)
				kludgeraw = 0;
			for (y = 0; y < towrite; ) {
#ifdef ECHOFIX	/* This makes things not echo for me. YMMV. */
				/* Check for IAC WILL ECHO;
				   newer telnet clients don't like to repeat
				   their answers, so if we have already asked
				   the client, simply pass on the same answer
				   to the server's question.
				   The IAC WILL ECHO is not likely to have
				   been split across the 1k buffer reads since
				   it is negotiated early.
				 */
				if (echomode && echorespond &&
				    (y < (towrite - 3)) &&
				    ((unsigned char)xuf[y] == IAC) &&
				    ((unsigned char)xuf[y+1] == WILL) &&
				    ((unsigned char)xuf[y+2] == TELOPT_ECHO)) {
					huf[0] = IAC;
					huf[1] = echorespond;
					huf[2] = TELOPT_ECHO;
					if (write(rfd, huf, 3) < 0) {
						say(0,"Remote server has closed connection");
						goto leave;
					}
					echorespond = 0;
					y += 3;
					continue;
				}
#endif /* ECHOFIX */
				if((x = write(0,&xuf[y],towrite - y)) < 0 && errno != EINTR) {
					say(0,"Remote server has closed connection");
					goto leave;
				}
				y += x;
			}
			inbytcnt += towrite;
		}
	}
leave:
	time(&offtime);
	syslog(LLEV,"exit host=%s/%s dest=%s in=%d out=%d user=%s duration=%d",
		rladdr,riaddr,dest,inbytcnt,outbytcnt,authuser,offtime - ontime);
	exit(0);
}



/*
we're not talking to a real telnet on the other side.
this means the proxy has to tell the client that any
telnet ops it wants to do are not allowed. this is
very suboptimal code, but then telnet is pretty
suboptimal in general.

PCNFS clients don't do correct newline mapping in
telnet mode (they only send ^M) so they still lose.
it's tempting to add prosthetic support but that
might break something else. feh.
*/
static	int
raw_telnet()
{
	unsigned char	j;
	unsigned char	jbuf[4];
	unsigned char	xbuf[512];
	unsigned char	obuf[512];
	int		bcnt;
	int		ocnt;
	int		bcur;

	/* this kludgy bit is because some telnet clients like
	to send a null as the first thing they transmit */
	static	int	sawnul = 0;

	bcnt = read(0,xbuf,sizeof(xbuf));
	if(bcnt <= 0)
		return(-1);

	ocnt = 0;
	for(bcur = 0; bcur < bcnt; bcur++) {
		/* kludge #1 */
		if(!sawnul && xbuf[bcur] == 0) {
			sawnul++;
			continue;
		}

		/* gather stuff to send to server */
		if(xbuf[bcur] != IAC) {
			obuf[ocnt++] = xbuf[bcur];
			continue;
		}

		/* shoot, it's a telnet option, spoof it */
		if(bcur + 1 == bcnt) {
			if(read(0,&j,1) != 1)
				return(-1);
		} else
			j = xbuf[++bcur];

		switch(j) {
		case WILL:
		case WONT:
			if(bcur + 1 == bcnt) {
				if(read(0,&j,1) != 1)
					return(-1);
			} else
				j = xbuf[++bcur];
			jbuf[0] = IAC;
			jbuf[1] = DONT;
			jbuf[2] = j;
			if(write(0,(char *)jbuf,3) != 3)
				return(-1);
			continue;

		case DO:
		case DONT:
			if(bcur + 1 == bcnt) {
				if(read(0,&j,1) != 1)
					return(-1);
			} else
				j = xbuf[++bcur];
			jbuf[0] = IAC;
			jbuf[1] = WONT;
			jbuf[2] = j;
			if(write(0,(char *)jbuf,3) != 3)
				return(-1);
			continue;
		}
	}
	if(ocnt > 0 && write(rfd,obuf,ocnt) != ocnt)
		return(-1);
	outbytcnt += ocnt;
	return(0);
}



static	void
trap_sigurg()
{
	int	atmark;
	char	buf[512];
	char	c;

	signal(SIGURG,trap_sigurg);
	while(1) {
		if(ioctl(0,SIOCATMARK,(char *)&atmark) < 0)
			return;
		if(atmark)
			break;
		read(0,buf,sizeof(buf));
	}
	if(rfd != -1) {
		if(recv(0,(char *)&c,sizeof(c),MSG_OOB) < 0)
			return;
		send(rfd,(char *)&c,sizeof(c),MSG_OOB);
	}
}



oktotalkto()
{
	Cfg	*cf;
	int	x;

	cf = cfg_get("hosts",confp);
	while(cf != (Cfg *)0) {
		if(cf->argc < 1)
			goto skip;
		
		for(x = 0; x < cf->argc && cf->argv[x][0] != '-'; x++) {
			if(hostmatch(cf->argv[x],riaddr)) {
				if(cf->flags & PERM_DENY) {
					syslog(LLEV,"deny host=%s/%s use of gateway",rladdr,riaddr);
					return(0);
				}
				syslog(LLEV,"permit host=%s/%s use of gateway",rladdr,riaddr);
				return(acceptrule(cf) == 0);
			}
		}
skip:
		cf = cfg_get("hosts",(Cfg*)0);
	}
	syslog(LLEV,"deny host=%s/%s use of gateway",rladdr,riaddr);
	return(0);
}




static	void
accept_setdest(v,c)
char	*v;
int	c;
{
	int	dests = 0;

	if(validests == (char **)0)
		validests = (char **)malloc(sizeof(char *) * 2);
	else {
		for(dests = 0; validests[dests] != (char *)0; dests++)
			;
		validests = (char **)realloc(validests,(dests + 2) * sizeof(char *));
	}
	if(validests == (char **)0)
		return;
	validests[dests] = v;
	validests[dests + 1] = (char *)0;
}




acceptrule(c)
Cfg	*c;
{
	int	x;
	void	(*op)();

	for(x = 1; x < c->argc; x++) {
		if(c->argv[x][0] != '-')
			continue;

		if(!strcmp(c->argv[x],"-auth")) {
			authneeded = 1;
			continue;
		}

		if(!strcmp(c->argv[x],"-passok")) {
			changeok = 1;
			continue;
		}

		if(!strcmp(c->argv[x],"-extnd")) {
			extendperm = 1;
			continue;
		}

		if(!strcmp(c->argv[x],"-xok")) {
			xgwok = 1;
			continue;
		}

		if (!strcmp(c->argv[x],"-startx") || !strcmp(c->argv[x],"-do-x")){
			xgwok = 1;
			doX = 1;
			continue;
		}

		if (!strcmp(c->argv[x], "-remhost")) {
			x++;
			if (x >= c->argc) {
				syslog(LLEV,"fwtkcfgerr: -remhost needs an argument, line %d",c->ln);
				exit(1);
			}
			strncpy(dest, c->argv[x], 511);
			dest[511] = '\0';
			continue;
		}

		/* options that take parameters and lists */
		op = 0;
		if(!strcmp(c->argv[x],"-dest"))
			op = accept_setdest;
		if(op == 0) {
			syslog(LLEV,"fwtkcfgerr: bad option line %d: %s",c->ln,c->argv[x]);
			exit(1);
		}
		if(++x >= c->argc) {
			syslog(LLEV,"fwtkcfgerr: malformed line %d: missing option",c->ln);
			exit(1);
		}
		if(!strcmp(c->argv[x],"{")) {
			while(1) {
				if(++x >= c->argc) {
					syslog(LLEV,"fwtkcfgerr: malformed line %d: missing option",c->ln);
					exit(1);
				}
				if(!strcmp(c->argv[x],"}"))
					break;
				(*op)(c->argv[x],c->ln);
			}
		} else
			(*op)(c->argv[x],c->ln);
	}
	return(0);
}



static	int
cmd_xforward(ac,av,cbuf)   
int	ac;
char	*av[];
char	*cbuf;
{
	Cfg     *confx, *cf;
	char	*fakav[16];
	char	buf[256], host[512];
	int	pid=0, i=0;

	if(xforwarder == (char *)0) {
		say(0,"X forwarder not available");
		return(0);
	}

	if(!xgwok) {
		say(0,"X forwarder not permitted");
		return(0);
	}
	sprintf(host,"%s/%s", rladdr, riaddr);

	fakav[i++] = "x-gw";
	fakav[i++] = "-from";
	fakav[i++] = rladdr;
	fakav[i++] = "-user";
	fakav[i++] = authuser;
	if (dest[0] == '\0') {
		fakav[i++] = "-prompt";
		fakav[i++] = prompt;
	}
	if (ac > 1) {
		fakav[i++] = "-display";
		fakav[i++] = av[1];

	}

	if((confx=cfg_read("x-gw")) != (Cfg *)-1 && (cf=cfg_get("timeout",confx)) != (Cfg *)0) {
		fakav[i++] = "-time";
		fakav[i++] = cf->argv[0];
	}
	fakav[i++] = NULL;

	if((pid = fork()) < 0) {
		syslog(LLEV, "fwtksyserr: cannot fork x-gw: %m" );
		say(0,"Cannot fork child process: system error");
		return(1);
	}

	if(pid > 0)
		return(0);

	if(execv(xforwarder,fakav) < 0) {
		sprintf(buf,"Can't execute: %s",cbuf);
		say(0,buf);
	}
	exit(0);
}


static	int
cmd_connect(ac,av,cbuf)
int	ac;
char	*av[];
char	*cbuf;
{
	static	char	narg[] = "No remote destination specified";
	static  char	buf[1024];
	char		*namp;
	short		port = TNPORT;

	if(ac < 2)
		return(sayn(0,narg,sizeof(narg)-1));


	if(ac > 2) {
		if(isalldigits(av[2]))
			port = atoi(av[2]);
		else {
			struct servent	*sp;

			sp = getservbyname(av[2],"tcp");
			if(sp != (struct servent *)0)
				port = ntohs(sp->s_port);
			else {
				sprintf(buf,"Unknown port/service: \"%s\"",av[2]);
				return(say(0,buf));
			}
		}
	}


	if(validests != (char **)0) {
		char	**xp;

		for(xp = validests; *xp != (char *)0; xp++) {
			if(**xp == '!' && hostmatch(*xp + 1,av[1])) {
				return(baddest(0,av[1]));
			} else if(**xp == '@' && hostmatch(*xp + 1, av[1])) {
				if(getauth()) {
					syslog(LLEV,"exit host=%s/%s no auth",rladdr, riaddr);
					exit(1);
				} else {
					extendperm = 1;
					break;
				}
			} else {
				if(hostmatch(*xp,av[1]))
					break;
			}
		}
		if(*xp == (char *)0)
			return(baddest(0,av[1]));
	}

	if(extendperm) {
		int	msg_int;
		char	mbuf[512];

		msg_int = auth_perm(confp,authuser,"telnet-gw",av[1],(char *)0);
		if(msg_int == 1) {
			sprintf(mbuf,"Permission denied for user %s to connect to %s",authuser,av[1]);
			say(0,mbuf);
			return(1);
		} else {
			if(msg_int == -1) {
				sprintf(mbuf,"No match in netperm-table for %s, to telnet to %s ",authuser,av[1]);
				say(0,mbuf);
				return(1);
		  	}
		}
	}


	if((namp = maphostname(av[1])) != (char *)0) {
		char	ebuf[512];

		syslog(LLEV,"permit host=%s/%s destination=%s",rladdr,riaddr,namp);
		sprintf(ebuf,"Trying %s port %d...",namp,port);
		if(say(0,ebuf))
			return(1);
	} else
		syslog(LLEV,"permit host=%s/%s destination=%s",rladdr,riaddr,av[1]);

	if (initialized && echomode) {
		unsigned char	xuf[9];

		xuf[0] = IAC;
		xuf[1] = WONT;
		xuf[2] = TELOPT_ECHO;
		xuf[3] = IAC;
		xuf[4] = WONT;
		xuf[5] = TELOPT_SGA;
		xuf[6] = IAC;
		xuf[7] = WONT;
		xuf[8] = TELOPT_TTYPE;
		if(write(0,xuf,9) != 9)
			return(1);
		kludgeraw = 1;
		echomode = 0;
	}

	if((rfd = conn_server(av[1],port,0,buf)) < 0) {
		char	ebuf[512];

		strcpy(ebuf,buf);
		sprintf(buf,"%s: %s",av[1],ebuf);
		return(say(0,buf));
	}

	syslog(LLEV,"connected host=%s/%s destination=%s",rladdr,riaddr,av[1]);
	strncpy(dest,av[1], 511);
	sprintf(buf, "Connected to %s.", dest);
	say(0, buf);
	return(2);
}



baddest(fd,dest)
int	fd;
char	*dest;
{
	Cfg	*cf;
	char	buf[BUFSIZ];

	syslog(LLEV,"deny host=%s/%s destination=%.256s",rladdr,riaddr,dest);
	if((cf = cfg_get("denydest-msg",confp)) != (Cfg *)0) {
		if(cf->argc != 1) {
			syslog(LLEV,"fwtkcfgerr: denydest-msg must have one parameter, line %d",cf->ln);
			return(1);
		}
		if(sayfile(fd,cf->argv[0])) {
			syslog(LLEV,"fwtksyserr: cannot display denydest-msg %s: %m",cf->argv[0]);
			return(1);
		}
		return(0);
	}
	sprintf(buf,"Not permitted to connect to %s",dest);
	return(say(fd,buf));
}




static	int
cmd_quit(ac,av,cbuf)
int	ac;
char	*av[];
char	*cbuf;
{
	static char	gby[] = "Disconnecting...";

	(void)sayn(0,gby,sizeof(gby)-1);
	time(&offtime);
	syslog(LLEV,"exit host=%s/%s dest=%s in=%d out=%d user=%s duration=%d",
		rladdr,riaddr,dest,inbytcnt,outbytcnt,authuser,offtime - ontime);

	exit(0);
}


static  int
cmd_timeout(ac,av,cbuf)
int     ac;
char    *av[];
char    *cbuf;
{
	static char	ok[] = "Timeout reset.";
	static char	nok[] = "Cannot set specified timeout.";

	if(ac < 2)
		goto notok;
	if((timeout = atoi(av[1])) < 0)
		goto notok;
	if(timeout == 0)
		timeout = (60 * 60 * 24 * 365); /* a year */
	return(sayn(0,ok,sizeof(ok)-1));

notok:
	timeout = PROXY_TIMEOUT;
	return(sayn(0,nok,sizeof(nok)-1));
}


static	int
cmd_help(ac,av,cbuf)
int	ac;
char	*av[];
char	*cbuf;
{
	Cfg		*cf;
	TnOp		*op;
	static char	hhdr[] = "Valid commands are: (unique abbreviations may be used)";

	if((cf = cfg_get("help-msg",confp)) != (Cfg *)0) {
		if(cf->argc != 1) {
			syslog(LLEV,"fwtkcfgerr: help-msg must have one parameter, line %d",cf->ln);
			return(1);
		}
		if(sayfile(0,cf->argv[0])) {
			syslog(LLEV,"fwtksyserr: cannot display help file %s: %m",cf->argv[0]);
			return(1);
		}
		return(0);
	}
	if(sayn(0,hhdr,sizeof(hhdr)-1))
		return(1);
	for(op = ops; op->name != (char *)0; op++) {
		if(op->hmsg != (char *)0)
			if(say(0,op->hmsg))
				return(1);
	}
	return(0);
}




static	int
cmd_passwd(ac,av,cbuf)
int	ac;
char	*av[];
char	*cbuf;
{
	static char	nochang[] = "Changing passwords not permitted from this host";
	static char	chprom[] = "Changing passwords";
	static char	prom[] = "Enter Username: ";
	static char	pprom[] = "Old Password: ";
	static char	npprom[] = "New Password: ";
	static char	nrpprom[] = "Repeat New Password: ";
	static char	badnpas[] = "Passwords do not match";
	static char	badfpas[] = "Passwords cannot contain quote characters";
	static char	noauth[] = "Cannot connect to authentication server";
	static char	toobad[] = "Too many failed login attempts";
	static char	toobig[] = "User-ID too long";
	static char	lostit[] = "Lost connection to authentication server";
	char		buf[512];
	char		ubuf[128];
	char		nbuf[128];
	int		bad = 5;
	int		x;

	if(!changeok) {
		if(sayn(0,nochang,sizeof(nochang)-1))
			return(1);
		return(0);
	}

	if(sayn(0,chprom,sizeof(chprom)-1))
		return(1);

	/* open connection to auth server */
	if(auth_open(confp)) {
		(void)sayn(0,noauth,sizeof(noauth)-1);
		return(1);
	}

	/* get welcome message from auth server */
	if(auth_recv(buf,sizeof(buf)))
		goto lostconn;
	if(strncmp(buf,"Authsrv ready",13)) {
		(void)say(0,buf);
		auth_close();
		return(1);
	}

	while(bad--) {
		/* prompt for user ID */
		if(write(0,prom,sizeof(prom)-1) != sizeof(prom)-1)
			return(1);

		/* get user ID from user */
		if(getline((unsigned char *)buf,sizeof(buf) - 1,prom,sizeof(prom)-1,1) < 0)
			return(1);

		/* send user ID to auth server */
		if((x = strlen(buf)) == 0)
			continue;
		if(x > 24) {
			if(sayn(0,toobig,sizeof(toobig)-1))
				return(1);
			continue;
		}

		strcpy(ubuf,buf);
		if(strlen(rladdr) + strlen(riaddr) + strlen(buf) + 100 > 512)
			sprintf(cbuf,"authorize %s",buf);
		else
			sprintf(cbuf,"authorize %s 'change-pw %s/%s'",buf,rladdr,riaddr);
		if(auth_send(cbuf))
			goto lostconn;
		while (1) {
			if(auth_recv(buf,sizeof(buf)))
				goto lostconn;
			if (!strncmp(buf,"ok",2)) {
				break;
			}
			if(!strncmp(buf,"display ",8)) {
				strcpy(cbuf,&buf[8]);
				x = strlen(cbuf);
				if (sayn(0, cbuf, x))
					return(1);
				strcpy(cbuf,"response dummy");
				if (auth_send(cbuf))
					goto lostconn;
				continue;
			}
			if(!strncmp(buf,"challenge ",10)) {
				x = strlen(&buf[10]);
				if(write(0,&buf[10],x) != x)
					return(1);
				if(getline((unsigned char *)buf,sizeof(buf) - 1,
					   cbuf,strlen(cbuf),1) < 0)
					return(1);
			} else 
			if(!strncmp(buf,"chalnecho ",10)) {
				x = strlen(&buf[10]);
				if(write(0,&buf[10],x) != x)
					return(1);
				if(getline((unsigned char *)buf,sizeof(buf) - 1,
					   cbuf,strlen(cbuf),0) < 0)
					return(1);
			} else
			if(!strncmp(buf,"password",8)) {
				if(write(0,pprom,sizeof(pprom)-1) != sizeof(pprom)-1)
					return(1);
				if(getline((unsigned char *)buf,sizeof(buf) - 1,
					   pprom,sizeof(pprom)-1,0) < 0)
					return(1);
			} else {
				break;
			}
			if (strlen(buf) > 64) {
				if(sayn(0, toobig, sizeof(toobig)-1))
					return(1);
				continue;
			}

			sprintf(cbuf, "response '%s'", buf);
			if(auth_send(cbuf))
				goto lostconn;
		}
		if (strncmp(buf,"ok", 2)) {
			if(say(0,buf))
				return(1);
			continue;
		}
		if(buf[2] != '\0') {
			if(say(0,&buf[2]))
				return(1);
		}

new_password:
		/* get new password */
		if(write(0,npprom,sizeof(npprom)-1) != sizeof(npprom)-1)
			return(1);
		if(getline((unsigned char *)buf,sizeof(buf) - 1,npprom,sizeof(npprom)-1,0) < 0)
			return(1);
		if(write(0,nrpprom,sizeof(nrpprom)-1) != sizeof(nrpprom)-1)
			return(1);
		if(getline((unsigned char *)nbuf,sizeof(nbuf) - 1,nrpprom,sizeof(nrpprom)-1,0) < 0)
			return(1);
		if(strcmp(buf,nbuf)) {
			if(sayn(0,badnpas,sizeof(badnpas)-1))
				return(1);
			goto new_password;
		}
		if(index(nbuf,'"') != (char *)0 || index(nbuf,'\'') != (char *)0) {
			if(sayn(0,badfpas,sizeof(badfpas)-1))
				return(1);
			goto new_password;
		}
		sprintf(buf,"password \"%s\"",nbuf);
		if(auth_send(buf))
			goto lostconn;
		if(auth_recv(buf,sizeof(buf)))
			goto lostconn;
		auth_close();
		return(say(0,buf));
	}
	auth_close();
	(void)sayn(0,toobad,sizeof(toobad)-1);
	return(1);

lostconn:
	auth_close();
	(void)sayn(0,lostit,sizeof(lostit)-1);
	return(1);
}



getauth()
{
	static char	prom[] = "Username: ";
	static char	pprom[] = "Password: ";
	static char	noauth[] = "Cannot connect to authentication server";
	static char	toobad[] = "Too many failed login attempts";
	static char	toobig[] = "User-ID too long";
	static char	lostit[] = "Lost connection to authentication server";
	static char	loggedin[] = "Login Accepted";
	char		buf[BSIZ];
	char		cbuf[128];
	char		ubuf[128];
	int		bad = 5;
	int		x;

	/* open connection to auth server */
	if(auth_open(confp)) {
		(void)sayn(0,noauth,sizeof(noauth)-1);
		return(1);
	}

	/* get welcome message from auth server */
	if(auth_recv(buf,sizeof(buf)))
		goto lostconn;
	if(strncmp(buf,"Authsrv ready",13)) {
		(void)say(0,buf);
		auth_close();
		return(1);
	}


	while(bad--) {
		/* prompt for user ID */
		if(write(0,prom,sizeof(prom)-1) != sizeof(prom)-1)
			goto close_go;

		/* get user ID from user */
		if(getline((unsigned char *)buf,sizeof(buf) - 1,prom,sizeof(prom)-1,1) < 0)
			goto close_go;

		/* send user ID to auth server */
		if((x = strlen(buf)) == 0)
			continue;
		if(x > 24) {
			if(sayn(0,toobig,sizeof(toobig)-1))
				goto close_go;
			continue;
		}

		strcpy(ubuf,buf);
		if(strlen(rladdr) + strlen(riaddr) + strlen(buf) + 100 > 512)
			sprintf(cbuf,"authorize %s",buf);
		else
			sprintf(cbuf,"authorize %s 'tn-gw %s/%s'",buf,rladdr,riaddr);
		if(auth_send(cbuf))
			goto lostconn;
		while (1) {
			if(auth_recv(buf,sizeof(buf)))
				goto lostconn;
			if (!strncmp(buf, "ok", 2)) {
				break;
			}
			if(!strncmp(buf,"display ", 8)) {
				strcpy(cbuf, &buf[8]);
				x = strlen(cbuf);
				if(sayn(0,cbuf,x))
					goto close_go;
				strcpy(cbuf,"response dummy");
				if(auth_send(cbuf))
					goto lostconn;
				continue;
                        } else
			if(!strncmp(buf,"challenge ",10)) {
				x = strlen(&buf[10]);
				if(write(0,&buf[10],x) != x)
					goto close_go;
				if(getline((unsigned char *)buf,sizeof(buf) - 1,
					   cbuf,strlen(cbuf),1) < 0)
					goto close_go;
			} else
			if(!strncmp(buf,"chalnecho ",10)) {
				x = strlen(&buf[10]);
				if(write(0,&buf[10],x) != x)
					goto close_go;
				if(getline((unsigned char *)buf,sizeof(buf) - 1,
					   cbuf,strlen(cbuf),0) < 0)
					goto close_go;
			} else
			if(!strncmp(buf,"password",8)) {
				if(write(0,pprom,sizeof(pprom)-1) != sizeof(pprom)-1)
					goto close_go;
				if(getline((unsigned char *)buf,sizeof(buf) - 1,
					   pprom,sizeof(pprom)-1,0) < 0)
					goto close_go;
			} else {
				break;
			}
			if (strlen(buf) > 64) {
				if(sayn(0, toobig, sizeof(toobig)-1))
					goto close_go;
				continue;
			}
			sprintf(cbuf,"response '%s'", buf);
			if (auth_send(cbuf))
				goto lostconn;
		}
		if(strncmp(buf,"ok",2)) {
			if(say(0,buf))
				goto close_go;
			continue;
		}
		if(buf[2] != '\0') {
			if (say(0,&buf[2]))
				goto close_go;
		}
		auth_close();
		syslog(LLEV,"authenticate user=%s",ubuf);
		strcpy(authuser,ubuf);
		return(sayn(0,loggedin,sizeof(loggedin)-1));
	}
	auth_close();
	(void)sayn(0,toobad,sizeof(toobad)-1);
	return(1);

lostconn:
	auth_close();
	(void)sayn(0,lostit,sizeof(lostit)-1);
	return(1);

close_go:
	auth_close();
	return(1);
}


usercmd(prompt,promptlen)
char	*prompt;
int	promptlen;
{
	TnOp		*op;
	static char	badcmd[] = "Command not understood";
	char		buf[BSIZ];
	char		tokbuf[BSIZ];
	char		*tokav[56];
	int		tokac;
	int		l;

	if(write(0,prompt,promptlen) != promptlen)
		return(1);
	if(getline((unsigned char *)buf,sizeof(buf) - 1,prompt,promptlen,1) < 0)
		return(1);
	if(buf[0] == '\0')
		return(0);

	tokac = enargv(buf,tokav,56,tokbuf,sizeof(tokbuf));
	if(tokac < 0) {
		if(sayn(0,badcmd,sizeof(badcmd)-1))
			return(1);
		return(0);
	}
	if(tokac == 0)
		return(0);

	/* if given only a FQDN (host.domain), assume the command is connect */
	if(strchr(tokav[0], '.')) {
		int narg;
		for (narg = tokac++; narg > 0; narg--)
			tokav[narg] = tokav[narg-1];
		tokav[0] = "connect";
	}
	l = strlen(tokav[0]);
	for(op = ops; op->name != (char *)0; op++) {
		if(!strncasecmp(tokav[0],op->name,l))
			return((*op->op)(tokac,tokav,buf));
	}

	sprintf(buf,"Command \"%s\" not recognized",tokav[0]);
	return(say(0,buf));
}



static  int
timeread(fd,buf,siz)
int	fd;
char	*buf;
int	siz;
{
	fd_set	r;
	struct	timeval timo;
	int	x;

	while (1) {
		timo.tv_sec = timeout;
		timo.tv_usec = 0;

		FD_ZERO(&r);
		FD_SET(fd,&r);
		x = select(fd + 1,&r,(fd_set *)0,(fd_set *)0,&timo);
		if (x == 0) {
			syslog(LLEV,"Network timeout signal after %d seconds",timeout);
			(void)say(fd,timed_out_msg);
			return(-1);	/* timeout */
		}
		if (x < 0) {
			if (errno == EINTR) continue;
			return -1;
		}
		break;
	}
	return(read(fd,buf,siz));
}


/*
BRUTAL kludgery necessary!!
*/
getline(buf,siz,pro,plen,echo)
unsigned char	*buf;
int		siz;
char		*pro;
int		plen;
int		echo;
{
	int		x = 0;

	if (!echo && !echomode) {
		unsigned char xuf[3];
		xuf[0] = IAC;
		xuf[1] = WILL;
		xuf[2] = TELOPT_ECHO;
		echomode++;
		if (write(0, xuf, 3) != 3)
			return(1);
	}
	while(1) {
		if(timeread(0,(char *)&buf[x],1) != 1)
			return(-1);

		/* handle telnet options */
		if(buf[x] == IAC) {
			unsigned char	xuf[3];
			unsigned char	gxa[3];

			gxa[0] = IAC;
			if (timeread(0, &gxa[1], 1) <= 0)
				return 1;

#ifdef xEOF
			/* control D */
			if (gxa[1] == xEOF) {
				(void) write(0, "\r\nEOF\r\n",7);
				return(-1);
			}
#endif
			/* EL = eraseline */
			if (gxa[1] == EL) {
				if (echomode && write(0,"\r\n",2) != 2)
					return(-1);
				x = 0;
				buf[x] = '\0';
				continue;
			}

			/* EC = erasechar */
			if (gxa[1] == EC) {
				unsigned char	xab[4];
				int		xac;

				/* backspace or bell */
				if (x > 0) {
					xab[0] = 0x08;
					xab[1] = 0x20;
					xab[2] = 0x08;
					xac = 3;
					x--;
				} else {
					xab[0] = 007;
					xac = 1;
				}
				if (echomode && write(0, xab, xac) != xac)
					return(-1);
				continue;
			}

			/* we only care about line echo option */
			if (timeread(0, &gxa[2], 1) <= 0)
				return(1);
			if (gxa[1] == DO) {
				if (gxa[2] == TELOPT_ECHO && !echomode) {
					xuf[0] = IAC;
					xuf[1] = WILL;
					xuf[2] = gxa[2];
					echomode++;
					if (write(0,xuf,3) != 3)
						return(1);
				}
				continue;
			}
			if ((gxa[1] == DONT || gxa[1] == DO) &&
			     gxa[2] == TELOPT_ECHO)
				echorespond = gxa[1];

			prebuf[prebufc++] = gxa[0];
			prebuf[prebufc++] = gxa[1];
			prebuf[prebufc++] = gxa[2];
			continue;
		}

		/* some telnets send NULL-terminated lines in NOECHO :( */
		if(buf[x] == '\0')
			continue;

		/* get \r\n - read a char and throw it away */
		if(buf[x] == '\r') {
			sawcr = 1;
			if(echomode && write(0,"\r\n",2) != 2)
				return(-1);
			buf[x] = '\0';
			return(x);
		}

		if(buf[x] == 4) {
			(void) write(0, "\r\nEOF\r\n",7);
			return(-1);
		}

		if(buf[x] == '\n') {
			if(sawcr) {
				sawcr = 0;
				continue;
			}
			if(echomode && write(0,"\r\n",2) != 2)
				return(-1);
			buf[x] = '\0';
			return(x);
		}
		sawcr = 0;

		/* control R */
		if(buf[x] == 18) {
			if(write(0,"\r\n",2) != 2)
				return(-1);
			if(write(0,pro,plen) != plen)
				return(-1);
			buf[x] = '\0';
			if(echo && write(0,buf,x) != x)
				return(-1);
			continue;
		}

		/* control U/ control C */
		if(buf[x] == 3 || buf[x] == 21) {
			if(write(0,"\r\n",2) != 2)
				return(-1);
			x = 0;
			buf[x] = '\0';
			return(x);
		}

		if(buf[x] == 127 || buf[x] == 8) {
			unsigned char	xab[4];
			int		xac;

			/* backspace or bell */
			if(x > 0) {
				xab[0] = 0x08;
				xab[1] = 0x20;
				xab[2] = 0x08;
				xac = 3;
				x--;
			} else {
				xab[0] = 007;
				xac = 1;
			}
			if(write(0,xab,xac) != xac)
				return(-1);
			continue;
		}

		if(!isprint(buf[x])) {
			unsigned char	xab[1];

			xab[0] = 007;
			if(write(0,xab,1) != 1)
				return(-1);
			continue;
		}

		if(echo) {
			if(echomode && write(0,(char *)&buf[x],1) != 1)
				return(-1);
		} else {
			if(write(0,"#",1) != 1)
				return(-1);
		}
		if(++x >= siz) {
			syslog(LLEV,"fwtksyserr: getline: buffer overrun");
			return(-1);
		}
	}
}



initialize()
{
	unsigned char	xuf[3];

	xuf[0] = IAC;
	xuf[1] = WILL;
	xuf[2] = TELOPT_ECHO;
	if(write(0,xuf,3) != 3)
		return(1);
	echomode = 1;
	return(0);
}


say(fd,s)
int	fd;
char	*s;
{
	return(sayn(fd,s,strlen(s)));
}



sayn(fd,s,n)
int	fd;
char	*s;
int	n;
{
	if(write(fd,s,n) != n)
		return(1);
	return(write(fd,"\r\n",2) != 2);
}



/* ugly */
sayfile(fd,fn)
int	fd;
char	*fn;
{
	FILE	*f;
	char	buf[BUFSIZ];
	char	*c;

	if((f = fopen(fn,"r")) == (FILE *)0)
		return(1);
	while(fgets(buf,sizeof(buf),f) != (char *)0) {
		if((c = index(buf,'\n')) != (char *)0)
			*c = '\0';
		if(say(fd,buf)) {
			fclose(f);
			return(1);
		}
	}
	fclose(f);
	return(0);
}


#ifdef	BINDDEBUG
debugbind()
{
	struct	sockaddr_in	mya;
	int	x;
	int	nread;

	if((x = socket(AF_INET,SOCK_STREAM,0)) < 0) {
		perror("socket");
		exit(1);
	}
	mya.sin_family = AF_INET;
	bzero(&mya.sin_addr,sizeof(mya.sin_addr));
#ifndef	BINDDEBUGPORT
	mya.sin_port = htons(TNPORT);
#else
	mya.sin_port = htons(BINDDEBUGPORT);
#endif
	if(bind(x,(struct sockaddr *)&mya,sizeof(mya))) {
		perror("bind");
		exit(1);
	}
	if(listen(x,1) < 0) {
		perror("listen");
		exit(1);
	}
	if((nread = accept(x,0,0)) < 0) {
		perror("accept");
		exit(1);
	}
	close(0);
	dup(nread);
	close(1);
	dup(nread);
}
#endif
