/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

 /*
  *      Author: Wei Xu, Trusted Information Systems, Inc.
*/
static  char    RcsId[] = "$Header: /usr/home/rick/fwtk2.0/fwtk/x-gw/RCS/fwd.c,v 1.5 1996/09/05 20:54:06 rick Exp $";

#include "ulib.h"
#include "list.h"
#include <netinet/in.h>
#include <sys/socket.h>
#include <signal.h>
#include <sys/time.h>


int	readfd( rfd,rset,wset,pbuf,bsize )
int	*rfd;
fd_set  *rset, *wset;
char    *pbuf;
int	 bsize;
{
        char     buf[64];
	int	 cnt,maxb=BUFSIZE-bsize;

	if( maxb <=0 ) return bsize;
	switch( cnt=read(*rfd,&pbuf[bsize],maxb) ) {
		case -1: sprintf(buf,"read fd:%d",readfd);  
			 pmsg(buf,1);
		case  0: clear_close_fd(*rfd,rset,wset);
			 cnt= -1;
			 break;
		default: if(cnt==maxb) FD_SET(*rfd,rset);
			 cnt+=bsize;
			 break;
	}
	return cnt;
}
int	writefd( wfd,rset,wset,pbuf,bsize )
int     *wfd;
fd_set  *rset, *wset;
char    *pbuf;
int	 bsize;
{
        char    buf[64];
	int	cnt;

	switch( (cnt=write(*wfd,pbuf,bsize)) ) {
		case -1: sprintf(buf,"write fd:%d",readfd);
			 pmsg(buf,1);
		case  0: clear_close_fd(*wfd,rset,wset);
			 return -1;
		default: if(cnt<bsize) {
				bcopy((void*)&(pbuf[cnt]),(void*)pbuf,
					(size_t)(bsize-cnt));
				FD_SET(*wfd,wset);
                         }
			 break;
	}
	return bsize-cnt;
}

/* *****pipe2sockets******************************
 * connect two sockets. 
 * This is a blocking loop handling/forwarding data
 * between two sockets so that at both of other
 * ends of the sockets looks just connected.
 *************************************************/
void	pipe2sockets( dest,from,timemax,idlemax,ppid )
int	dest,    from;
int	timemax, idlemax;
pid_t   ppid;
{
	fd_set	 readable, writable;
	char     pbuffrom[BUFSIZE+1]; /* buf from dest forwarding to from */
	char	 pbufdest[BUFSIZE+1]; /* buf from from forwarding to dest */
	int      szfrom=0,  szdest=0; /* buf size of pbufxxx */
	fd_set   rset,	 wset;
	int	 ret, maxfd;

	maxfd=max(dest,from)+1;
	FD_SET(dest,&rset);	FD_SET(dest,&wset);
	FD_SET(from,&rset);	FD_SET(from,&wset);

	for(;;) {
		readable=rset; writable=wset;

		ret=serv_select(maxfd,&readable,
			(szfrom>0 || szdest>0) ? &writable : (fd_set *) 0,
			timemax,idlemax);
		if( ret<0 ) {
			if(-ret==EINTR) continue;
			break;
		}
		else if(!ret) continue;

		if(FD_ISSET(from,&readable) && 
		   (szfrom=readfd(&from,&rset,&wset,pbuffrom,szfrom))<0)
		   break;

		if(FD_ISSET(dest,&readable) &&
		   (szdest=readfd(&dest,&rset,&wset,pbufdest,szdest))<0)
		   break;;

		if(szdest>0 && FD_ISSET(from,&writable) &&
		   (szdest=writefd(&from,&rset,&wset,pbufdest,szdest))<0)
		   break;

		if(szfrom>0 && FD_ISSET(dest,&writable) &&
		   (szfrom=writefd(&dest,&rset,&wset,pbuffrom,szfrom))<0)
		   break;

		if(ppid>=0 && ppid!=getppid()) break;
	}
}

static pid_t	query_conn( fd, 	fwd, 
			    rset,	wset,
			    conn_query_cb, userdata,
			    timemax, 	idlemax,
			    dependchild )
int     fd;
struct  sockaddr_in fwd;
fd_set  *rset,   *wset;
int   (*conn_query_cb)();
void   *userdata;
int     timemax, idlemax;
int	dependchild;
{
	int                 querysock, outgoing,
			    saddrlen=sizeof(struct sockaddr_in);
	pid_t               pid;
	struct sockaddr_in  saddr;

       /* new connection */
       if( (querysock=accept(fd,(struct sockaddr *)&saddr,&saddrlen)) < 0 ) {
		if( errno != EINTR ) pmsg("accept",TRUE);
		return -1;
	}
#ifndef WEI_DBG
	if( (pid=fork())< 0) {
		pmsg("Forking child failed",1);
		return -1;
	} else if( pid ) {
		FD_SET(querysock,rset); FD_SET(querysock,wset);
		close(querysock);
		return pid;
	}
	for(pid=0;pid<3;pid++) {
		if(pid != querysock)
			close(pid);
	}
#endif
	/* ************************************************
	 * if conn_query_cb return <0, there is something
	 * error and to quit the query_conn
	 **************************************************/
	if(conn_query_cb(querysock,saddr,userdata)>=0) {
		time_t		    ontime;
		time(&ontime);
		if( (outgoing=conn_sd(fwd))<0 ) 
			goto out;
		pipe2sockets(outgoing,querysock,timemax,idlemax,
			    (dependchild)?getppid():-1);
		close(outgoing);
		exitmsg( ontime, "child" );
	} 
out:	close(querysock); 
	exit(1);
}

list_t *fwd_loop( lsock,	fwd,
		  timemax,	idlemax,
		  conn_query_cb,userdata,
		  app_cb,	chldexitcb,
		  app_data,	dependchild)
int      lsock;            /* the local socket		*/
struct   sockaddr_in fwd;  /* the forward addr		*/
int      timemax, 	   /* serv select timeout	*/
	 idlemax;	   /* if >0, fwd_loop idle timeout. */
int    (*conn_query_cb)(); /* handle callback when connection requested */
void    *userdata;	   /* pass userdata for conn_query_cb 		*/
int    (*app_cb)();	   /* handle application routines while looping */
			   /* return <0 to stop looping			*/
int    (*chldexitcb);	   /* handle children exit callback
			    * return < -1 to keep the pid in the list   */
void    *app_data;	   /* pass data for both app_cb and chldexitcb	*/
int	 dependchild;	   /* if dependchild, all children is to be 	*/
			   /* killed when timeout. Otherwise the 	*/
			   /* children will keep alive.			*/
{
    register	int       n;

    int		fds=lsock+1;
    list_t	*pids=NULL;
    fd_set	allset,	rset, wset;
    pid_t	pid;        /* may need to handle child exit */

    FD_ZERO(&allset); FD_ZERO(&wset); FD_ZERO(&rset); FD_SET(lsock,&allset);
    
    while (1) {
	rset=allset;
        if((n=serv_select(fds,&rset,NULL,timemax,idlemax)<0)) {
	    if(-n==EINTR) continue;
	    break;
	}
	    
	if(FD_ISSET(lsock,&rset)) {
		pid = query_conn( lsock, 	 fwd, 
				  &rset,	 &wset,
				  conn_query_cb, userdata,
				  timemax,	 idlemax,
				  dependchild ); 
	       	if( pid<0 ) exit(1);
		pids=(list_t*)setList(pids,pid,(void*)pid);
	} 
	pids=(list_t*)chldsigs(pids,chldexitcb,app_data);

        if( app_cb && app_cb(lsock,fwd,pids,allset,app_data)<0 ) break;
    } 
    return pids;
}

