/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Wei Xu, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: /usr/users/rick/fwtk/fwtk/x-gw/RCS/pmsg.c,v 1.2 1996/03/27 02:14:16 rick Exp $";


#include        "ulib.h"
#include        <syslog.h>

int uselog=0;



/*******************************************************
 *  perrno: use strerror()
 *  uselog must be set before puting msg to the log 
 *         file which can also be used as debeg ouputs.
 *******************************************************/
void pmsg( msg, perrno )
char *msg;
int   perrno;
{
   char    buf[BUFSIZE];

   if( perrno ) {
       sprintf( buf, "%s: %s\n", msg, strerror(errno) );
       msg=buf;
   }

   if( uselog ) syslog( LLEV, msg );
   else {
       fprintf( stderr, msg );
       fflush(stderr);
   }
}

void exitmsg( ontime, msg )
time_t	ontime;
char	*msg;	/* additional msgs */
{
	char    buf[256];
	time_t  offtime;

	time(&offtime);
	if(!msg) sprintf( buf,"exit duration=%d seconds\n",offtime-ontime );
	else  sprintf( buf,"%s exit duration=%d seconds\n",msg,offtime-ontime );
	pmsg(buf,0);

	if(uselog) closelog();
}   

dump_struct(pmsg,data,sz)
	char    *pmsg;
        caddr_t data;
	int     sz;
{
	int     i,cnt=0,chex=0;
	u_char *p=(u_char *)data;

	printf("%s(%d bytes):",pmsg,sz);
	for(i=0;i<sz;i++) {
		printf("%02x ",*p++);
		cnt++; chex++;
		if(cnt==8) {
			printf("\n");
			cnt=0;
		}
	}
	if(cnt) printf("\n");
}

