/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/* part of htp-gw
 */

#include "http-gw.h"

/* unesc
 *
 * remove the %xx escapes from the selector and strip off
 * the HTTP/version string.
 */

struct res_chars{
int	prototyp;
char	*chars;
};

struct res_chars	res_chars[] = {
	{ TYPE_HTTP, "/;?"},
	{ 0, NULL}
};


int unhex(f, np)
char *f;
int *np;
{	int n, ch;

	if(f[1] == '\0' || f[2] == '\0'){	/* Broken URL */
		return 0;
	}
	ch = f[1];
	if( ch >= '0' && ch <= '9')
		n = 16*(ch-'0');
	else if( ch >= 'A' && ch <= 'F')
		n = 16*(ch-'A'+10);
	else if( ch >= 'a' && ch <= 'f')
		n = 16*(ch-'a'+10);
	else { /* not valid hex escape */
		return 0;
	}
	ch = f[2];
	if( ch >= '0' && ch <= '9')
		n += ch-'0';
	else if( ch >= 'A' && ch <= 'F')
		n += ch-'A'+10;
	else if( ch >= 'a' && ch <= 'f')
		n += ch-'a'+10;
	else {
		return 0;
	}
	if( np)
		*np = n;
	return 1;
}

int unesc(t, f, proto)
char *t, *f;
int proto;
{	 int n;
	char ch;
	char *p, *st = t;
	char *res = "";

	if( proto){
		struct res_chars *rp = res_chars;

		while(rp->prototyp){
			if( rp->prototyp & proto){
				res = rp->chars;
				break;
			}
		}
	}


	while(*f){
		if( *f == '%'){
			if( !unhex(f, &n)){
				*t++ = *f++;
				continue;
			}
			if( n != 0 && strchr(res, n) == NULL){
				*t++ = n;
				f = &f[3];
			}else{ /* don't expand reserved */
				*t++ = *f++;
				*t++ = *f++;
				*t++ = *f++;
			}
		}else {
			*t++ = *f++;
		}
	}

	return 0;
}

/* Save the original request. */

int must_escape(ch)
int ch;
{
	if( ch <= ' ')
		return 1;
	if( ch & 0x80)
		return 1;
	if( ch == 0x7f)
		return 1;
	if( ch == '%')
		return 1;
	return 0;
}

/* copy data escaping stuff that needs to be escaped */

int copy_with_escapes(dest, src, len, proto)
char *dest, *src;
int len, proto;
{	int cnt, n;
	char *res = "";
	char *saved = dest;

	if( proto){
		struct res_chars *rp = res_chars;

		while(rp->prototyp){
			if( rp->prototyp & proto){
				res = rp->chars;
				break;
			}
		}
	}

	cnt = 1;
	while(*src){
/* don't escape already escaped reserved chars */
		if( *src == '%' && unhex(src, &n) && strchr(res, n)){
			*dest++ = *src++;
			cnt++;
			if( cnt >= len-3)
				break;
			*dest++ = *src++;
			cnt++;
			*dest++ = *src++;
			cnt++;
		}else if( must_escape(*src) ){
			sprintf(dest, "%%%02x", *src & 0xff);
			dest += 3;
			cnt += 3;
			if( cnt >= (len -3))
				break;
			src++;
		}else{
			*dest++ = *src++;
			cnt++;
			if( cnt >= len-1)
				break;
		}
	}
	*dest = '\0';
	return 0;
}

