/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */


#include "http-gw.h"


int starthtml(sockfd, msg)
int sockfd;
char *msg;
{

	if( msg == NULL)
		msg = "";

	say(sockfd,"HTTP/1.0 200 OK");
	say(sockfd,"Content-type: text/html");
	say(sockfd,"");

	say(sockfd,"<HEAD>");
	if( rem_type & TYPE_FTP){
		sprintf(go_request,"<title>FTP %s at %s</title>", msg, rem_server);
		say(sockfd, go_request);
		say(sockfd,"</HEAD>");
		say_sub(sockfd,"<h1>FTP "); 
	}else{
		sprintf(go_request,"<title>Gopher %s for %s</title>", msg, rem_server);
		say(sockfd, go_request);
		say(sockfd,"</HEAD>");
		say_sub(sockfd,"<h1>Gopher "); 
	}
	if( *msg){
		say_sub(sockfd,msg);
	}
	say(sockfd,"</h1>");
	return 0;
}

int gostartmenu(sockfd)
int sockfd;
{
	if( rem_type & TYPE_HTTP){
		starthtml(sockfd,"Menu"); 
		say(sockfd,"<HR>");
	}
	return 0;
}

int goendmenu(sockfd)
int sockfd;
{	char *p;

	if( rem_type & TYPE_HTTP){
		say(sockfd,"<br><hr>");
		p = ver_str;

		while(*p && *p != ' ')p++;
		if( rem_type & TYPE_PROXYCLIENT){
			sprintf(go_request,
				"<A HREF=\"http://-internal-/-http-gw-internal-/version.html\">http-gw version %s</A>", p);
		}else{
			sprintf(go_request,
				"<A HREF=\"http://%s:%d/http://-internal-/-http-gw-internal-/version.html\">http-gw version %s</A>",
				ourname, ourport, p);
		}
		say(sockfd, go_request);
		sprintf(go_request," (%s)", ourname);
		say(sockfd, go_request);
	}
	return 0;
}

int gostarthtml(sockfd)
int sockfd;
{
	if( rem_type & TYPE_HTTP){
		starthtml(sockfd,"Text");
		say(sockfd,"<HR><PRE>");
	}
	return 0;
}

int goendhtml(sockfd)
int sockfd;
{
	say(sockfd,"</PRE>");
	return 0;
}


int goputmenu(sockfd, menu)
int sockfd;
char *menu;
{	char *p, *q;
	int ch;
	char **parse_vec;
	static char abuf[GO_REQ_LEN+512];

	if( rem_type & TYPE_HTTP){
		say(sockfd, "<LI>");
		parse_vec = reply_parse( menu);
		if( parse_vec == NULL){
			say(sockfd, menu);
			return 0;
		}else if(rem_type & TYPE_PROXYCLIENT){
			sprintf(abuf, "<A HREF=\"http://%s:%s/%s\">%s</A>",
				parse_vec[2], parse_vec[3], parse_vec[1], parse_vec[0]);
		}else {
			sprintf(abuf, "<A HREF=\"gopher://%s:%s/7%s\">%s</A>",
				parse_vec[2], parse_vec[3], parse_vec[1], parse_vec[0]);
		}
		say(sockfd, abuf);
	}else{
		say(sockfd, menu);
	}

	return 0;
}

/* 12 oct 94 new error processing */
int gostarterror(sockfd, errno)
int sockfd, errno;
{	static int outresponse = 0;

	if( (rem_type & (TYPE_HTTP|TYPE_HTTPREQ|TYPE_PROXYCLIENT)) || rem_typech == 'h'){
		if( outresponse == 0){
			outresponse = 1;
			sprintf(errbuf,"HTTP/1.0 %d Error", errno);
			say(sockfd, errbuf);
			say(sockfd, "Content-type: text/html");
			say(sockfd,"");
		}
		if( rem_type & TYPE_FTP){
			say_sub(sockfd,"<h1>FTP Error"); 
		}else{
			say_sub(sockfd,"<h1>Error"); 
		}
		sprintf(errbuf, "- %d</h1>", errno);
		say(sockfd,errbuf);
		say(sockfd,"<HR>");
	}else {
		if( rem_type& TYPE_DIR){
			if(rem_type & TYPE_FTP)
				say(sockfd,"-FTP Error\t\t\t");
			else
				say(sockfd,"-Error\t\t\t");
			say(sockfd,"---------------------------------------\t\t\t");
		}else if( rem_type & TYPE_TEXT){
			if(rem_type & TYPE_FTP)
				say(sockfd,"FTP Error");
			else
				say(sockfd,"Error");
			say(sockfd,"----------------------------------------");
		}
	}
	return 0;
}

int goenderror(sockfd)
int sockfd;
{
	if( rem_type & (TYPE_PROXYCLIENT|TYPE_HTTP)){
		rem_type |= TYPE_HTTP;
		goendmenu(sockfd);
	}
	return 0;
}

int go_error(sockfd, errno, msg, va_alist)
int sockfd;
int errno;
char *msg;
va_dcl
{	static int last_errno = 0;
	va_list marker;

	if( errno != last_errno){	/* flush previous error stuff */
		if( last_errno){
			goenderror(sockfd);
		}
		last_errno = errno;
		if( last_errno){
			gostarterror(sockfd, errno);
		}
	}
	if( msg != NULL){
		va_start(marker);
		vsprintf(errbuf, msg, marker);
		va_end(marker);
		if( (rem_type & (TYPE_HTTP|TYPE_DIR)) == (TYPE_DIR)){
			say_sub(sockfd,"-");
		}
		say_sub(sockfd, errbuf);
		if( (rem_type & (TYPE_HTTPREQ|TYPE_PROXYCLIENT)) || rem_typech == 'h'){
			say(sockfd, "<br>");
		}else if( rem_type & TYPE_DIR){
			say(sockfd, "\t\t\t");
		}else {
			say(sockfd, " ");
		}
	}

	return 0;
}


