/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/* Gopher/Http IO module
 * By P.J.Churchyard
 * Copyright (c) 1994
 * All rights reserved.
 */

#include "http-gw.h"

#include "gio.h"

#ifndef GBLOCK_SIZE
#define GBLOCK_SIZE 1024
#endif

GBUF *new_gbuf()
{	GBUF *ret;

	ret = (GBUF *)malloc(sizeof(GBUF));

	if( ret == NULL){
		syslog(LLEV,"new_gbuf out of memory");
		return NULL;
	}

	ret->next = ret->prev = NULL;

	ret->data = NULL;
	ret->length = ret->flag = ret->pos = 0;

	return ret;
}

GFILE *new_gfile()
{	GFILE *ret;

	ret = (GFILE *)malloc(sizeof(GFILE));

	if( ret == NULL){
		syslog(LLEV,"new_gfile out of memory");
		return NULL;
	}

	ret->next = NULL;
	ret->driver = NULL;
	ret->data = NULL;
	ret->flag = 0;

	return ret;
}


/* top level routines */

int g_read(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	GBUF *ret;

	if( gf == NULL || gbp == NULL){
		return -1;
	}

	if( gf->driver == NULL || gf->driver->g_read == NULL){
		return -1;
	}

	return (*gf->driver->g_read)(gf, gbp);
}


int g_write(gf, gbp)
GFILE *gf;
GBUF **gbp;
{

	if( gf == NULL || gbp == NULL){
		return -1;
	}

	if( gf->driver == NULL || gf->driver->g_write == NULL){
		return -1;
	}

	return (*gf->driver->g_write)(gf, gbp);
}


/* basic network read/write stuff */

struct gnet_rec {
int	fd;
};


int g_netread(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	struct gnet_rec *gnr;
	GBUF *buf;
	int cnt;

	buf = new_gbuf();
	buf->data = (char *)malloc(GBLOCK_SIZE);

	gnr = (struct gnet_rec *)gf->data;

	cnt = read(gnr->fd, buf->data, GBLOCK_SIZE);
	if( cnt > 0){
		buf->length = cnt;
		*gbp = buf;
	}else{
		free(buf->data);
		free(buf);
		*gbp = NULL;
	}
	return cnt;
}

int g_netwrite(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	struct gnet_rec *gnr;
	GBUF *buf;
	int cnt;

	gnr = (struct gnet_rec *)gf->data;

	buf = *gbp;

	cnt = write(gnr->fd, buf->data, buf->length);

	free(buf->data);
	free(buf);
	*gbp = NULL;
	return cnt;
}

GDEV gnetdev={
g_netread,
g_netwrite
};

GFILE *gnet_open(fd)
int fd;
{	GFILE *ret = new_gfile();
	struct gnet_rec *gnr;

	if( ret == NULL){
		return NULL;
	}

	gnr = (struct gnet_rec *)malloc(sizeof(struct gnet_rec));
	if( gnr == NULL){
		free(ret);
		ret = NULL;
	}else{
		ret->data = (char *)gnr;
		gnr->fd = fd;
	}

	return ret;

}



/* basic file read/write stuff */

struct gfiledev_rec {
int	fd;
};


int g_fileread(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	struct gfiledev_rec *gnr;
	GBUF *buf;
	int cnt;

	buf = new_gbuf();
	buf->data = (char *)malloc(GBLOCK_SIZE);

	gnr = (struct gfiledev_rec *)gf->data;

	cnt = read(gnr->fd, buf->data, GBLOCK_SIZE);
	if( cnt > 0){
		buf->length = cnt;
		*gbp = buf;
	}else{
		free(buf->data);
		free(buf);
		*gbp = NULL;
	}
	return cnt;
}

int g_filewrite(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	struct gfiledev_rec *gnr;
	GBUF *buf;
	int cnt;

	gnr = (struct gfiledev_rec *)gf->data;

	buf = *gbp;

	cnt = write(gnr->fd, buf->data, buf->length);

	free(buf->data);
	free(buf);
	*gbp = NULL;
	return cnt;
}

GDEV gfiledev={
g_fileread,
g_filewrite
};

GFILE *gfile_open(fd)
int fd;
{	GFILE *ret = new_gfile();
	struct gfiledev_rec *gnr;

	if( ret == NULL){
		return NULL;
	}

	gnr = (struct gfiledev_rec *)malloc(sizeof(struct gfiledev_rec));
	if( gnr == NULL){
		free(ret);
		ret = NULL;
	}else{
		ret->data = (char *)gnr;
		gnr->fd = fd;
	}

	return ret;

}

/* basic memory read stuff */



