/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 *		Peter J. Churchyard, Trusted Information Systems, Inc.
 *
 *	22-Aug-1994	Started to add the Gopher+ stuff. (pjc)
 *	29-Jan-1995	Tidy up various things (pjc)
 */
static	char	RcsId[] = "$Header: hmain.c,v 1.2 95/02/27 12:53:47 pjc Exp $";

#define DEFINE_DATA

#include "http-gw.h"
#include <sys/wait.h>

struct str_arg_rec {
char	*name;
char	*buf;
int	length;
};

struct str_arg_rec string_arg_tab[] = {
{ "directory", 		go_directory, 		PATH_MAX-1},
{ "default-gopher",	def_server,		MAXHOSTNAMELEN+5},
{ "default-httpd",	def_httpd,		MAXHOSTNAMELEN+5},
{ "icon-source",	default_icon_url,	MAXHOSTNAMELEN+5},
{ "ftp-proxy",		ftp_proxy,		MAXHOSTNAMELEN+5},
{ NULL,	NULL,	0}
};

int fwtk_get_string_args( tab)
struct str_arg_rec *tab;
{	int flag = 0;
	Cfg	*cf;

	while(tab && tab->name != NULL){
		if((cf = cfg_get(tab->name,confp)) != (Cfg *)0) {
			if(cf->argc != 1) {
				syslog(LLEV,"%s must have one parameter, line %d",tab->name, cf->ln);
				flag = 1;
			}else {
				strncpy(tab->buf, cf->argv[0], tab->length);
			}
		}
		
		tab++;
	}
	return flag;
}


void http_exit(ret)
int ret;
{
	syslog(LLEV,"exit host=%s/%s code=%d", rladdr, riaddr, ret);
	exit(ret);
}


int do_chroot_etc()
{

	if( go_directory[0]){
		chdir("/");
		if( chdir(go_directory)){
			syslog(LLEV,"chdir %s: %m", go_directory);
			http_exit(1);
		}
	
		if( chroot(go_directory)){
			syslog(LLEV,"chroot %s: %m", go_directory);
			http_exit(1);
		}
		chdir("/");
	}
	
	if(rungid != -1 && setgid(rungid)) {
		syslog(LLEV,"cannot setgid %d: %m",rungid);
		http_exit(1);
	}

	if(runuid != -1 && setuid(runuid)) {
		syslog(LLEV,"cannot setuid %d: %m",runuid);
		http_exit(1);
	}
	return 0;
}

char *makestring(str)
char *str;
{	int leng;
	char *ret;

	if( str == NULL)
		return NULL;

	leng = strlen(str);
	ret = (char *)malloc( leng+1);

	if( ret != NULL){
		strncpy(ret, str, leng);
		ret[leng] = '\0';
	}
	return ret;
}


/* Start of main code */
extern void trap_neterr();

/*  Lets get going... */
main(ac,av)
int	ac;
char	*av[];
{
	Cfg		*cf;
	int		x;
static struct sockaddr_in serv_addr;
	int		length = sizeof(serv_addr);

	if( ac == 2 && !strcmp(av[1], "-version")){
		printf("http-gw:   %s\n", ver_str);
		exit(0);
	}

#ifndef	LOG_DAEMON
	openlog("http-gw",LOG_PID);
#else
	openlog("http-gw",LOG_PID|LOG_NDELAY,LFAC);
#endif

/*  read the time, catch some signals */

	time(&ontime);
	signal(SIGURG,trap_sigurg);
	signal(SIGPIPE,trap_neterr);

	authuser[0] = '\0';
	strcpy(autheduser,"unauth");

		
	while(ac > 1){
		ac--;
		av++;

		switch(av[0][1]) {
#ifdef DODEBUG
		case 'D':
			DEBUG |= 1;
			debugf = stderr;
			break;

		case 'd':
			DEBUG |= 2;
			debugf = fopen(optarg, "a");
			if( debugf == NULL){
				DEBUG = 0;
				syslog(LLEV,"failed to append to file %s", optarg);
			}
			setvbuf(debugf, NULL, _IONBF, (size_t)0);
			break;
#endif
		default:
			syslog(LLEV,"bad command line option -%c",av[0][1]);
			exit(1);
		}
	}
	

#ifdef	DEBUG

	if( DEBUG && ac > 1){
		ac--;
		av++;
		goport = atoi(av[0]);
	}

	if(DEBUG&1){
		debugbind();
	}
#endif
	confp = cfg_read("http-gw");

	fconfp = cfg_read("ftp-gw");
	if( confp == NULL || confp == (Cfg *)-1)
		confp = fconfp;

	if( confp == NULL || confp == (Cfg *)-1){
		syslog(LLEV,"Failed to get any netperm-table entries");
		exit(1);
	}

	if(gethostname(ourname,sizeof(ourname)))
		strcpy(ourname,"unknown");
#ifndef NO_GETHOSTBYNAME
	ourhe = gethostbyname ( ourname);
	if( NULL != ourhe){
		strcpy(ourname, ourhe->h_name);
	}
#endif


	if( getsockname(0, (struct sockaddr *) &serv_addr, &length)){
		syslog(LLEV,"cannot get our port");
		exit(1);
	}
	ourport = ntohs(serv_addr.sin_port);

	if(peername(0,rladdr,riaddr,sizeof(riaddr))) {
		syslog(LLEV,"cannot get peer name");
		exit(1);
	}


	if((cf = cfg_get("groupid",confp)) != (Cfg *)0) {

		if(cf->argc != 1) {
			syslog(LLEV,"groupid must have one parameter, line %d",cf->ln);
			http_exit(1);
		}
		if((rungid = mapgid(cf->argv[0])) == -1) {
			syslog(LLEV,"cannot map %s to gid",cf->argv[0]);
			http_exit(1);
		}
	}

	if((cf = cfg_get("userid",confp)) != (Cfg *)0) {

		if(cf->argc != 1) {
			syslog(LLEV,"userid must have one parameter, line %d",cf->ln);
			http_exit(1);
		}
		if((runuid = mapuid(cf->argv[0])) == -1) {
			syslog(LLEV,"cannot map %s to uid",cf->argv[0]);
			http_exit(1);
		}
	}


	if( fwtk_get_string_args( string_arg_tab)){
		http_exit(1);
	}
/* suggested by Daniel W. Woycke <woycke@mitre.org */
	if((cf = cfg_get("url-filter",confp)) != (Cfg *)0) {

		if(cf->argc != 1) {
			syslog(LLEV,"url-filter must have one parameter, line %d",cf->ln);
			http_exit(1);
		}
		unesc(default_url_filter, cf->argv[0], 0);
	}

	/* see if this is someone we are even willing to converse with */
	if(!oktotalkto()) {
		sprintf(nouse_msg,"Sorry, Access denied for %s (%s)",rladdr,riaddr);
	}

	timeout.tv_usec = 0;
	if((cf = cfg_get("timeout",confp)) != (Cfg *)0) {
		if(cf->argc != 1) {
			syslog(LLEV,"timeout must have one parameter, line %d",cf->ln);
			http_exit(1);
		}
		if((timeout.tv_sec = atoi(cf->argv[0])) <= 0) {
			syslog(LLEV,"timeout %s invalid, line %d",cf->argv[0],cf->ln);
			http_exit(1);
		}
	} else
		timeout.tv_sec = 10*60;

/* load the noproxy list */

	if( (cf = cfg_get("noproxy", confp)) != (Cfg *)0){
		while(cf != (Cfg *)0){
			if( cf->argc < 3){
				syslog(LLEV,"noproxy takes atleast 3 arguments, line %d", cf->ln);
			}else{
				if( strcmp("-ident", cf->argv[cf->argc-2])){
					syslog(LLEV,"noproxy: should be ... -ident NAME, line %d", cf->ln);
				}else if( !strcmp(ident, cf->argv[cf->argc-1])){
					for(x=0; x < cf->argc-2; x++){
						add_noproxy(cf->argv[x]);
					}
				}
			}
			cf = cfg_get("noproxy", (Cfg *)0);
		}
	}

	if( (cf = cfg_get("forward", confp)) != (Cfg *)0){
		while(cf != (Cfg *)0){
			if( cf->argc < 5){
				syslog(LLEV,"forward takes atleast 5 arguments, line %d", cf->ln);
			}else{
				if( strcmp("-tohost", cf->argv[cf->argc-2]) ||
				    strcmp("-protocol", cf->argv[cf->argc-4])){
					syslog(LLEV,"forward: should be ... -protocol PROTO -tohost HOSTNAME, line %d", cf->ln);
				}else {
					for(x=0; x < cf->argc-4; x++){
						add_forward(cf->argv[x], cf->argv[cf->argc-3], cf->argv[cf->argc-1]);
					}
				}
			}
			cf = cfg_get("forward", (Cfg *)0);
		}
	}


/* read the request */
	if( getline(0, go_request, 1023) >= 0)
		process_request(0, go_request);

	time(&offtime);
	syslog(LLEV,"exit host=%s/%s cmds=1 in=%d out=%d user=%s duration=%d",
		rladdr,riaddr,inbytcnt, outbytcnt,autheduser, offtime - ontime);
	go_error(0, 0, NULL);	/* flush error messages */
	exit(0);
}




/* read it and weep */
void
trap_sigurg()
{
	int	atmark;
	char	buf[512];

	signal(SIGURG,trap_sigurg);
	while(1) {
		if(ioctl(0,SIOCATMARK,(char *)&atmark) < 0)
			return;
		if(atmark)
			break;
		read(0,buf,sizeof(buf));
	}
}

void 
net_timeout()
{
	syslog(LLEV,"Network timeout signal after %d seconds", timeout.tv_sec);
	http_exit(1);
}

void
trap_neterr()
{
	syslog(LLEV,"Network connection closed during write");
	http_exit(1);
}

/* Check to see if we even talk to this client! */

oktotalkto()
{
	Cfg	*cf, *tp;
	int	x;

	permissions = G_ALL;		/* Start with all */

	tp = confp;
	cf = cfg_get("hosts",confp);
	if( cf == (Cfg *)0){
		tp = fconfp;		/* No http-gw: hosts rules */
	}
	cf = cfg_get("hosts",tp);
	while(cf != (Cfg *)0) {
		if(cf->argc < 1)
			goto skip;
		for(x = 0; x < cf->argc; x++) {
			if(cf->argv[x][0] == '-')
				break;
			if(hostmatch(cf->argv[x],riaddr)) {
				if(cf->flags == PERM_DENY) {
					syslog(LLEV,"deny host=%s/%s use of gateway",rladdr,riaddr);
					return(0);
				}
				syslog(LLEV,"permit host=%s/%s use of gateway (%s)",rladdr,riaddr, ver_str);
				return(acceptrule(cf) == 0);
			}
		}

skip:
		cf = cfg_get("hosts",(Cfg*)0);
	}
	syslog(LLEV,"deny host=%s/%s use of gateway (%s)",rladdr,riaddr, ver_str);
	return(0);
}


static	void
accept_setdest(v,c)
char	*v;
int	c;
{
	int	dests = 0;

	if(validests == (char **)0)
		validests = (char **)malloc(sizeof(char *) * 2);
	else {
		for(dests = 0; validests[dests] != (char *)0; dests++)
			;
		validests = (char **)realloc(validests,(dests + 2) * sizeof(char *));
	}
	if(validests == (char **)0)
		return;
	validests[dests] = v;
	validests[dests + 1] = (char *)0;
}


/* Gopher specific options processing
 */
struct pars_opts{
char *name;
int type;
}p_opts[] = {
{"all", G_ALL},
{"dir", G_DIR},
{"read",G_READ},
{"exec",G_EXEC},
{"wais",G_WAIS},
{"plus",G_PLUS},
{"write",G_WRITE},
{"ftp" ,G_FTP},
{"http",G_HTTP},
{"gopher",G_GOPHER},
/* Now come some of the ftp-gw style options */
{"retr",G_READ},
{"stor",G_WRITE},
/* for logging only */
{"type",G_CONTYPE},
{ NULL, G_NOPERM}
};


int	parse_options(s)
char *s;
{	struct pars_opts *t = p_opts;

	while(t->name){
		if( !strcasecmp(s, t->name))
			return t->type;
		t++;
	}
	return G_NOPERM;
}

static void accept_options(v, c)
char *v;
int	c;
{
	permissions |= parse_options(v);
}

static void
deny_options(v, c)
char *v;
int	c;
{	int x;

	x = parse_options(v);
	if( x != G_NOPERM){
		permissions &= ~x;
	}
}

static void
filter_options(v, c)
char *v;
int	c;
{
	filter_replies |= parse_options(v);
}



static void
log_options(v, c)
char *v;
int	c;
{
	logging |= parse_options(v);
}


static void
auth_options(v, c)
char *v;
int	c;
{
	auth_funcs |= parse_options(v);
	return;
}

acceptrule(c)
Cfg	*c;
{
	int	x, y;
	void	(*op)();

	for(x = 1; x < c->argc; x++) {
		/* skip nonoptions */
		if(c->argv[x][0] != '-')
			continue;

		/* options that take no parameters */
		if(!strcmp(c->argv[x],"-nooutput")) {
			permissions &= ~G_WRITE;	/* No write */
			blockoutput = 1;
			continue;
		}
		if(!strcmp(c->argv[x],"-noinput")) {
			permissions &= ~G_READ;		/* No read */
			blockinput = 1;
			continue;
		}
		if(!strcmp(c->argv[x],"-authall")){
			auth_funcs = G_ALL;
			continue;
		}

		if(!strcmp(c->argv[x],"-gopher")){
			if( x+1 >= c->argc){
				syslog(LLEV,"config line %d: -gopher needs an argument.", c->ln);
				return 0;
			}
			strncpy(def_server, c->argv[x+1], MAXHOSTNAMELEN+5);
			x++;
			continue;
		}
		if(!strcmp(c->argv[x],"-httpd")){
			if( x+1 >= c->argc){
				syslog(LLEV,"config line %d: -httpd needs an argument.", c->ln);
				return 0;
			}
			strncpy(def_httpd, c->argv[x+1], MAXHOSTNAMELEN+5);
			x++;
			continue;
		}
		if(!strcmp(c->argv[x],"-name")){
			if( x+1 >= c->argc){
				syslog(LLEV,"config line %d: -name needs an argument.", c->ln);
				return 0;
			}
			strncpy(ourname, c->argv[x+1], MAXHOSTNAMELEN+5);
			x++;
			continue;
		}
		if(!strcmp(c->argv[x],"-ident")){
			if( x+1 >= c->argc){
				syslog(LLEV,"config line %d: -ident needs an argument.", c->ln);
				return 0;
			}
			strncpy(ident, c->argv[x+1], MAXHOSTNAMELEN+5);
			x++;
			continue;
		}

		/* options that take parameters and lists */
		op = 0;
		if(!strcmp(c->argv[x],"-dest"))
			op = accept_setdest;
		else if(!strcmp(c->argv[x],"-permit")){
			permissions = G_NOPERM;
			op = accept_options;
		}
		else if(!strcmp(c->argv[x],"-deny"))
			op = deny_options;
		else if(!strcmp(c->argv[x],"-filter")){
			filter_replies = G_NOPERM;
			op = filter_options;
		}
		else if(!strcmp(c->argv[x],"-log")){
			logging = G_NOPERM;
			op = log_options;
		}else if(!strcmp(c->argv[x],"-auth")){
			op = auth_options;
		}

		if(op == 0) {
			syslog(LLEV,"bad option line %d: %s",c->ln,c->argv[x]);
			continue;
		}
		if(++x >= c->argc) {
			syslog(LLEV,"malformed line %d: missing option",c->ln);
			continue;
		}
		if(!strcmp(c->argv[x],"{")) {
			while(1) {
				if(++x >= c->argc) {
					syslog(LLEV,"malformed line %d: missing option",c->ln);
					continue;
				}
				if(!strcmp(c->argv[x],"}"))
					break;
				(*op)(c->argv[x],c->ln);
			}
		} else
			(*op)(c->argv[x],c->ln);
	}
	return(0);
}

/* read a line from the connection */

getline(fd,buf,siz)
int		fd;
unsigned char	*buf;
int		siz;
{
	int	x = 0;
	int	ret = -1;

	(void) signal(SIGALRM, net_timeout);
	(void) alarm(timeout.tv_sec);
	while(1) {
		if(read(fd,(char *)&buf[x],1) != 1)
			goto done;

		/* get \r\n - read a char and throw it away */
		if(buf[x] == '\r') {
			if(read(fd,(char *)&buf[x],1) != 1)
				goto done;
			buf[x] = '\0';
			ret = x;
			goto done;
		}

		if(buf[x] == '\n') {
			buf[x] = '\0';
			ret = x;
			goto done;
		}

		if(buf[x] == IAC) {
			unsigned char	j;
			unsigned char	jbuf[4];

			if(read(fd,&j,1) != 1)
				goto done;

			switch(j) {
			case WILL:
			case WONT:
				if(read(fd,(char *)&j,1) != 1)
					goto done;
				jbuf[0] = IAC;
				jbuf[1] = DONT;
				jbuf[2] = j;
				if(write(fd,(char *)jbuf,3) != 3)
					goto done;
				continue;
			case DO:
			case DONT:
				if(read(fd,(char *)&j,1) != 1)
					goto done;
				jbuf[0] = IAC;
				jbuf[1] = WONT;
				jbuf[2] = j;
				if(write(fd,(char *)jbuf,3) != 3)
					goto done;
				continue;
			case IAC:
				x = 0;
				continue;
			case IP:
				if(read(fd,(char *)&j,1) != 1)
					goto done;
				if(j == DM)
					x = 0;
				continue;
			}
		}

		if(++x >= siz) {
			syslog(LLEV,"getline: buffer overrun");
			goto done;
		}
	}
done:
	(void) alarm(0);
	(void) signal(SIGALRM, SIG_IGN);
	return ret;
}


say_sub(fd,s)
int	fd;
char	*s;
{	int	n;
	n = strlen(s);

	return(write(fd,s,n) != n);
}

say(fd,s)
int	fd;
char	*s;
{
	return(sayn(fd,s,strlen(s)));
}



sayn(fd,s,n)
int	fd;
char	*s;
int	n;
{
	if(write(fd,s,n) != n)
		return(1);
	return(write(fd,"\r\n",2) != 2);
}



#ifdef	DEBUG

debugbind()
{
	static	int	x;
	int	nread;


	if( x == 0){
		x = make_conn(goport);
		if(listen(x,5) < 0) {
			syslog(LLEV,"Listen failed");
			perror("listen");
			http_exit(1);
		}
	}
	if((nread = accept(x,0,0)) < 0) {
		syslog(LLEV,"Accept failed");
		perror("accept");
		http_exit(1);
	}
	close(0);
	dup(nread);
	close(1);
	dup(nread);
}


#endif

