/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/* Header for the http-gw and gopher-gw
 */

#include	<stdio.h>
#include	<ctype.h>
#include	<syslog.h>
#include	<sys/signal.h>
#include	<sys/ioctl.h>
#include	<sys/errno.h>
#include	<sys/param.h>
#include	<limits.h>
extern	int	errno;
extern	char	*sys_errlist[];
#include	<arpa/ftp.h>
#include	<arpa/telnet.h>
#include	<sys/time.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<string.h>
#include	<varargs.h>


#include	<net/if.h>
#ifndef VERSION
#include	"version.h"
#endif

#include	"internal.h"

extern	char	*rindex();
extern	char	*index();
extern	char	*strtok();
extern	char	*inet_ntoa();

extern	char	*optarg;

#include	"firewall.h"

#ifndef	VERSION
#define	VERSION	"0.9"
#endif

#ifndef	BSIZ
#define	BSIZ	2048
#endif

#ifndef	FTPPORT
#define	FTPPORT	21
#endif


#ifndef GOPORT
#define GOPORT 70
#endif

#ifndef HTTPPORT
#define HTTPPORT 80
#endif

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

/* Define some data types used to determine what to do for this transaction */
/* These are returned by the routines that parse the 'path' */
#define TYPE_UNKNOWN 0
#define TYPE_DIR 1
#define TYPE_TEXT 2
#define TYPE_BINARY 4
#define TYPE_EXEC 8
#define TYPE_WAIS 0x10

#define MASK_BASE (TYPE_DIR|TYPE_TEXT|TYPE_BINARY|TYPE_EXEC|TYPE_WAIS)

/* the following are not 'base' types */
#define TYPE_READ 0x40		/* It is a read data type */
#define TYPE_WRITE 0x80		/* it is a write data type */
#define	TYPE_FTP 0x100		/* Its an ftp type operation */
#define TYPE_PLUS 0x200		/* It is a gopher plus operation */
#define TYPE_HTTP 0x400		/* It is an http operation */
#define TYPE_HTTPREQ 0x800	/* need to talk to an HTTP server */
#define TYPE_PROXYCLIENT 0x1000	/* The client knows about proxies */
#define TYPE_LOCAL	0x2000	/* Auth stuff etc */
#define TYPE_GOPHER	0x4000
#define TYPE_TELNET	0x8000

#ifndef DEFINE_DATA
#define EXTERN extern
#else
#define EXTERN
#endif

EXTERN	Cfg			*confp;
EXTERN	char			**validests;

EXTERN	Cfg			*fconfp;		/* used to get ftp-gw entries */
EXTERN	int			blockinput;
EXTERN	int			blockoutput;

EXTERN	int			rfd
#ifdef DEFINE_DATA
 = -1
#endif
;	/* fd to remote */
EXTERN	int			boundport
#ifdef DEFINE_DATA
 = -1
#endif
;
EXTERN	struct sockaddr_in	clntport;
EXTERN	char			riaddr[512];
EXTERN	char			rladdr[512];

EXTERN	int			authenticated;
EXTERN	char			authuser[128];
EXTERN	char			autheduser[128];	/* successful */

EXTERN	time_t			ontime;
EXTERN	time_t			offtime;
EXTERN	int			inbytcnt;
EXTERN	int			outbytcnt;
EXTERN	int			cmdcnt;

EXTERN	struct timeval	timeout;
EXTERN	int		runuid
#ifdef DEFINE_DATA
 = -1
#endif
;
EXTERN	int		rungid
#ifdef DEFINE_DATA
 = -1
#endif
;
/* START OF GOPHER SPECIFIC STUFF */

#ifdef DODEBUG
EXTERN int			DEBUG;
EXTERN int			goport;		/* only used for debugging */
EXTERN FILE *debugf;

#define Debug(x) if(DEBUG)fprintf x;
#else
#define Debug(x);
#endif

EXTERN	char			ourname[MAXHOSTNAMELEN+6];
EXTERN	int			ourport;
EXTERN	struct hostent		*ourhe;

EXTERN	void	trap_sigurg();
EXTERN	void	net_timeout();

#define GO_REQ_LEN (PATH_MAX+10+MAXHOSTNAMELEN+5)/* This should be enough*/
EXTERN	char	go_request[GO_REQ_LEN];
EXTERN	char	orig_request[GO_REQ_LEN*3];
EXTERN	char	go_directory[PATH_MAX];
EXTERN	char	def_server[MAXHOSTNAMELEN+6];	/* where to hand off to */
EXTERN	int	def_port;
EXTERN char	def_httpd[MAXHOSTNAMELEN+6];
EXTERN	int	def_hport;

EXTERN 	char	ftp_proxy[PATH_MAX];		/* what ftp-proxy to use */
EXTERN	int	ftp_proxy_port;
EXTERN	char	ftp_user[MAXHOSTNAMELEN+20];	/* what usercmd to send */
EXTERN	char	ftp_pass[80];
EXTERN	char	ftp_server[MAXHOSTNAMELEN];


EXTERN	char	rem_server[MAXHOSTNAMELEN+6];
EXTERN	int	rem_type;			/* what type of request */
EXTERN	int	rem_typech;			/* the gopher type char */
EXTERN	char	rem_path[PATH_MAX];
EXTERN	int	rem_port;
EXTERN	int	chk_type_ch;			/* Set by check_req */

EXTERN	char	nouse_msg[PATH_MAX];		/* name of use denial 
							   msg file. also used 
							   as the flag! */
/* Now define the permission flags that affect what they can do */
#define G_NOPERM	0
#define G_DIR		1	/* can get directories */
#define G_READ		2	/* can read files */
#define G_EXEC		4	/* can 'exec' */
#define G_WAIS		8	/* can do WAIS searches */
#define G_PLUS		0x10	/* can do gopher+ and HTTP/1.x stuff */
#define G_WRITE		0x20	/* can do gopher+ or HTTP post uploads */
#define G_FTP		0x40	/* can do ftp commands */
#define G_HTTP		0x80	/* can do http commands */
#define G_GOPHER	0x100	/* can do gopher requests */
#define G_CONTYPE	0x200	/* for logging content-type */
#define G_ALL		0xffff	/* can do every thing */

EXTERN	int	permissions
#ifdef DEFINE_DATA
=G_ALL
#endif
;
EXTERN	int	filter_replies
#ifdef DEFINE_DATA
 = G_NOPERM
#endif
;
EXTERN	int	logging
#ifdef DEFINE_DATA
 = G_ALL
#endif
;
EXTERN	int	auth_funcs;		/* What we need auth for */
EXTERN	char	auth_token[1024];
EXTERN	char	tmp_auth_buf[GO_REQ_LEN+512];

extern	char	*makestring();
extern	char	**reply_parse();

EXTERN char errbuf[GO_REQ_LEN*3];	/* used by many, tmp storage */

/* Some HTTP specific variables */
EXTERN	char	http_protocol[80];	/* also used as a flag... */
EXTERN	char	http_method[80];	/* what method, "" == GET */

/* handle TELNET type stuff through proxy */

struct reproxy_rec {
struct reproxy_rec *next;
char	*protocol;
char	*command;
};

EXTERN	struct reproxy_rec *reproxy_list;

EXTERN	char		priaddr[512];
EXTERN	char		prladdr[512];

EXTERN	char		mime_type[128];
EXTERN	char		default_icon_url[GO_REQ_LEN];


/* 29-Dec-1994 */
EXTERN	char		ver_str[];

struct noproxy_rec {
struct noproxy_rec *next;
char *host;
};

EXTERN	struct noproxy_rec *noproxy_list;
EXTERN	char		ident[MAXHOSTNAMELEN+6];

struct forward_rec {
struct forward_rec *next;
char *path;
char *protocol;
char *host;
};

extern struct forward_rec *find_forward();
EXTERN struct forward_rec *forward_list;
EXTERN char forward_host[MAXHOSTNAMELEN+6];

EXTERN char default_url_filter[512];
