%{
/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * scanner for sfc configuration file
 *
 * $Id: config.l,v 1.18 1995/07/13 14:37:44 roland Rel $
 *
 */

#include <string.h>
#include <unistd.h>

void sferrorl(char *); /* see config.y */

%}

%x comment

%%

setup						{return(T_SETUP);}
rules						{return(T_RULES);}
reject						{return(T_REJECT);} 
block|drop					{return(T_BLOCK);} 
accept|permit					{return(T_ACCEPT);}
with						{return(T_WITH);} 
","						{return(T_COMMA);} 
":"						{return(T_COLON);} 
";"						{return(T_SEMICOLON);}
"\\"						{return(T_BACKSLASH);}
"("|")"						{return(T_PARAN);}
".""."(".")?					{return(T_DOTDOT);}
(icmp_)?net_unreachable				{return(T_NET_UNREACHABLE);} 
(icmp_)?host_unreachable			{return(T_HOST_UNREACHABLE);}
(icmp_)?proto(col)?_unreachable 		{return(T_PROTO_UNREACHABLE);}
(icmp_)?port_unreachable			{return(T_PORT_UNREACHABLE);}
all						{return(T_ALL);}
from						{return(T_FROM);} 
to						{return(T_TO);} 
port(s)?					{return(T_PORT);}
mask						{return(T_MASK);}
icmp						{return(T_ICMP);} 
igmp						{return(T_IGMP);} 
tcp						{return(T_TCP);} 
udp						{return(T_UDP);} 
rip						{return(T_RIP);}
(rr|record_route)				{return(T_IPOPT_RR);} 
(ts|time_?stamp)				{return(T_IPOPT_TS);} 
sec(urity)?					{return(T_IPOPT_SECURITY);} 
(lsrr?|loose_source_route)			{return(T_IPOPT_LSRR);} 
(sat_?id|satnet_id)				{return(T_IPOPT_SATID);}
(ssrr?|strict_source_route)			{return(T_IPOPT_SSRR);}
(icmp_)?echo_reply				{return(T_ICMP_ECHOREPLY);} 
(icmp_)?dest(ination)?_unreach(able)?		{return(T_ICMP_DEST_UNREACH);} 
(icmp_)?source_quench				{return(T_ICMP_SOURCE_QUENCH);}
(icmp_)?redirect				{return(T_ICMP_REDIRECT);} 
(icmp_)?echo_req(uest)?				{return(T_ICMP_ECHO);} 
(icmp_)?time_exceeded				{return(T_ICMP_TIME_EXCEEDED);} 
(icmp_)?param(eter)?_prob(lem)?			{return(T_ICMP_PARAMETERPROB);}
(icmp_)?time_?stamp_req(uest)?			{return(T_ICMP_TIMESTAMP);} 
(icmp_)?time_?stamp_reply			{return(T_ICMP_TIMESTAMPREPLY);} 
(icmp_)?info_req(uest)?				{return(T_ICMP_INFO_REQUEST);}
(icmp_)?info_reply				{return(T_ICMP_INFO_REPLY);} 
(icmp_)?address_mask_req(uest)?			{return(T_ICMP_ADDRESS);} 
(icmp_)?address_mask_reply			{return(T_ICMP_ADDRESSREPLY);}
(igmp_)?host_membership_query			{return(T_IGMP_HOST_MEMBERSHIP_QUERY);} 
(igmp_)?host_membership_report			{return(T_IGMP_HOST_MEMBERSHIP_REPORT);}
(igmp_)?host_leave_message			{return(T_IGMP_HOST_LEAVE_MESSAGE);}
notification					{return(T_NOTIFICATION);} 
not(ification)?_level				{return(T_NOTIFICATION_LEVEL);} 
level						{return(T_LEVEL);}
relevel						{return(T_RELEVEL);}
mail						{return(T_MAIL);} 
spy						{return(T_SPY);} 
syslog						{return(T_SYSLOG);}
message						{return(T_MESSAGE);}
exec						{return(T_EXEC);} 
if						{return(T_IF);} 
then						{return(T_THEN);} 
endif						{return(T_ENDIF);} 
"="						{return(T_EQUAL);} 
"!="|"<>"					{return(T_NEQUAL);} 
">"						{return(T_GREATER);} 
"<"						{return(T_SMALLER);} 
route						{return(T_ROUTE);} 
via						{return(T_VIA);}
opt(ions)?					{return(T_OPTIONS);} 
internalnets					{return(T_INTERNALNETS);}
let						{return(T_LET);}
":="						{return(T_ASSIGNMENT);}
"+"						{return(T_PLUS);}
"-"						{return(T_MINUS);}
ttl|time_to_live				{return(T_TTL);}
device(name)?					{return(T_DEVICE);}
mail_def(ault)?					{return(T_MAIL_DEFAULT);}
inside						{return(T_INSIDE);}
outside						{return(T_OUTSIDE);}
currentprotocol					{return(T_CURPROTO);}
sourcehost					{return(T_SOURCEHOST);}
sourcenet					{return(T_SOURCENET);}
desthost					{return(T_DESTHOST);}
destnet						{return(T_DESTNET);}
timeout						{return(T_TIMEOUT);}
end\.						{return(T_END);}
spoof						{return(T_SPOOF);}

"-"?[0-9]+			{ yylval.integer = 
                                    strtol(yytext, (char **)NULL, 10);
				  return(NUMBER); }
\"[^\"]+\"			{ if (strlen(yytext) > (STRSIZE - 1))
                                    { sferrorl("string too long");
				      strncpy(yylval.string,
                                              yytext, (STRSIZE - 1)); 
                                      yylval.string[STRSIZE-1] = 0;
                                    }
				  else
				    { strcpy(yylval.string, yytext); }
				  return(STRING); }
([0-9]{1,3}"."){3,3}[0-9]{1,3}  { if (strlen(yytext) > (STRSIZE - 1))
                                    { sferrorl("ip address too long");
				      strncpy(yylval.string,
                                              yytext, (STRSIZE - 1));
                                      yylval.string[STRSIZE-1] = 0;
                                    }
                                  else
                                    { strcpy(yylval.string, yytext); }
				  return(IP_ADDRESS); }

"/*"				BEGIN(comment);

^(#|%).*\n			{ yylineno++; }	

[ \t\r\f\b]			

[A-Z]

\n				{ yylineno++; }

[a-z0-9]+			{ if (strlen(yytext) > (STRSIZE - 1))
                                    { sferrorl("identifier too long");
				      strncpy(yylval.string,
                                              yytext, (STRSIZE - 1));
                                      yylval.string[STRSIZE-1] = 0;
                                    }
                                  else
                                    { strcpy(yylval.string, yytext); }
                                  return(IDENTIFIER); } 

<comment>[^*\n]*                  
<comment>"*"+[^*/\n]*             
<comment>\n			{ yylineno++; }
<comment>"*"+"/"                BEGIN(INITIAL);

%%

int yywrap()
{ return(1); }

