/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * $id$
 */

#ifndef _SF_CONTROL_H
#define _SF_CONTROL_H

#define	SF_CONTROL_MAGIC 0x524F524F				/* RORO */

struct sf_control {
	unsigned long magic;
	int command;
	char data[0];
};

#define	SF_COMMAND_DISABLE	0
#define	SF_COMMAND_ENABLE	1
#define SF_COMMAND_CLEAR_LOST	2
#define SF_COMMAND_FW_CLEAR	3	/* delete all firewall chains */
#define SF_COMMAND_FW_ADD	4	/* add entry to firewall */
#define SF_COMMAND_FW_REPLACE	5	/* replace firewall entry having given id */
#define SF_COMMAND_FW_DELETE	6	/* delete firewall entry having given id */
#define SF_COMMAND_FW_ADDR	7	/* replace address array */
#define SF_COMMAND_FLUSH	8	/* delete all active TCP connections 
					   that are no longer allowed */
#define SF_COMMAND_FLUSH_ALL	9	/* abort all active TCP connections */

#endif /* _SF_CONTROL_H */
