/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * sf firewall user customizable parameters. 
 *
 * $Id: sf_custom.h,v 1.12 1995/08/05 15:03:43 robby Rel $
 */

#ifndef _SF_CUSTOM_H
#define _SF_CUSTOM_H

/*
 * Files and paths
 */

#define LOG		"/var/adm/firewall"	/* location of firewall log file */
#define SPY_LOG		"/var/adm/firewall.spy"	/* counter intelligence results */
#define DEFAULT_CONFIG	"/etc/firewall.conf"	/* default configuration file */
#define PID_FILE	"/etc/firewall.pid"	/* path to pid file */
                                        	/* /var/run/firewall.pid is OK, too */
#define NPIPE		"/etc/firewall.pipe"	/* named pipe for configuration data */
#define DEVICE		"/dev/firewall"		/* path to the firewall device */
#define SFIDENT		"/usr/local/bin/sfident"/* path to the identd query program */

#define MAIL		"/usr/sbin/sendmail"	/* location of the send-mail program */

#define FINGER		"/usr/bin/finger"	/* location of the finger program */
#define FINGER_ARG	"-pl"			/* arguments for finger */

#define SPY_USING_RUSERS			/* use rusers to gather information */
#define RUSERS		"/usr/bin/rusers"	/* location of the rusers program */
#define RUSERS_ARG	"-al"			/* arguments for rusers */


/*
 * Environment
 */

#define DISK_MINFREE	2048			/* KB free space required on log disk */
#define UNPRIV_NAME	"firewall"		/* Unprivileged user name for daemon */
#define REPLY_TO	"nobody"		/* reply path for mails, if defined */
#define PRIORITY	"urgent"		/* mail priority, if defined */

/*
 * Miscellaneous preferences - no need to change these
 */ 

#define TIME_FORMAT	"%b %d %X"		/* time format for log entries */
#define SPOOF_MESSAGE	"IP packet spoofing detected!" 
#define MAX_REPEATS	100			/* maximum message repeat counter */
#define MAX_HOLD	2*60			/* max. delay for repeated msgs. (seconds) */
#define SPY_TIMEOUT	5*60			/* don't spy more often than every five minutes */

#define MAX_IF		10			/* max. number of network interfaces */
						/* needed for spy/identd ONLY */

#endif

