/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * Exported functions and variables for the sf firewall user mode log module.
 *
 * $Id: sf_daemon.h,v 1.11 1995/08/05 11:50:15 robby Rel $
 */

#ifndef _SF_DAEMON_H
#define _SF_DAEMON_H

extern int fdlock;                      /* file descriptors for the lock file */
extern int fddev;                       /* and the firewall device */

extern struct sf_fw rule_spoof;         /* rule for spoofing */

extern void init_log(void);             /* initialize the data structures */
extern void start_log(char *);          /* start the log function */
extern time_t add_event(void (*proc)(int,int), int, int, int); 
                                        /* Add event to the event queue */
extern void prepare_for_exec(void);     /* prepare for exec */
extern FILE *mail(char *addressee);     /* create a mail handle to addressee */

#endif
