/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * $Id: sf_filter.h,v 1.20 1995/08/05 11:37:46 robby Rel $
 *
 */

#ifndef _SF_FILTER_H
#define _SF_FILTER_H

/*
 *	Format of the data structure which is passed to the 
 *	The size of the structure should not exceed a page size (4K).
 */

#define PROC_SIZE_IP		176

/* special rule identifiers for implicit rules */
#define RULE_SPOOF_RECV		-1	/* packet received on wrong interface */
#define RULE_SPOOF_XMIT		-2	/* packet sent via wrong interface */

struct sf_proc_entry {
	int action;			/* action code (= return code)  */
	union {
	  long num;			/* rule number			*/
	  struct sf_fw *ptr;		/* pointer to rule		*/
	} rule;
	char devname[8];		/* device address		*/
	char ip_packet[PROC_SIZE_IP];	/* ip packet (first N bytes)  	*/
};

#define NUM_PROC_ENTRIES	21

struct sf_proc {
	unsigned num_entries;		/* number of valid records	*/
	unsigned long lost_entries;	/* number of lost packets	*/
	struct sf_proc_entry data[NUM_PROC_ENTRIES];
};

/*
 *	Variables for interaction with the driver
 */

/* filter use count */
extern int sf_fw_enabled;

/* packet filtering routine */
extern int sf_check_packet(struct iphdr *, struct device *, int);

/* configuration update */
extern int sf_write_config(char *, int);

/* temporary storage for packets to be sent to the daemon */
extern struct sf_proc sf_log_data;

/* wait queue for synchronization between kernel filter module and daemon */
extern struct wait_queue *sf_log_entry;

/* delete all timers, must be called before unloading the module */
extern void sf_del_all_timers(void);

/* initialize all data structures */
extern int sf_init(void);

/* read actual configuration */
extern long sf_rule_first(void);
extern long sf_rule_next(void);

#endif /* _SF_FILTER_H */
