/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * sf Firewall protocol names
 *
 * $Id: sf_proto.c,v 1.2 1995/07/13 14:37:44 roland Rel $
 */

#include "sf_proto.h"

/*
 * Protocol names, taken from RFC 1340. This array is used for displaying
 * the names only and changing it will merely change the log output.
 * Note! The RFC is updated every year or so.
 */

char *protocol[] ={"Prot. 0",     /*  0  Reserved */
                   "ICMP",        /*  1  Internet Control Message */
		   "IGMP",        /*  2  Internet Group Management */
		   "GGP",         /*  3  Gateway-to-Gateway */
		   "IP encap.",   /*  4  IP in IP (encapsulation) */
		   "ST",          /*  5  Stream */
		   "TCP",         /*  6  Transmission Control */ 
		   "UCL",         /*  7  UCL */ 
		   "EGP",         /*  8  Exterior Gateway Protocol */ 
		   "IGP",         /*  9  Any private interior gateway */
		   "BBN-RCC-MON", /* 10  BBN-RCC-MON BBN RCC Monitoring */
		   "NVP-II",      /* 11  Network Voice Protocol */
		   "PUP",         /* 12  PUP */
		   "ARGUS",       /* 13  ARGUS */
		   "EMCON",       /* 14  EMCON */
		   "XNET",        /* 15  Cross Net Debugger */
		   "CHAOS",       /* 16  Chaos */
		   "UDP",         /* 17  User Datagram */
		   "MUX",         /* 18  Multiplexing */
		   "DCN-MEAS",    /* 19  Measurement Subsystems */
		   "HMP"          /* 20  Host Monitoring */
		   "PRM",         /* 21  Packet Radio Measurement */
		   "XNS-IDP",     /* 22  XEROX NS IDP */
		   "TRUNK-1",     /* 23  Trunk-1 */
		   "TRUNK-2",     /* 24  Trunk-2 */
		   "LEAF-1",      /* 25  Leaf-1 */
		   "LEAF-2",      /* 26  Leaf-2 */
		   "RDP",         /* 27  Reliable Data Protocol */
		   "IRTP",        /* 28  Internet Reliable Transaction */
		   "ISO-TP4",     /* 29  ISO Transport Protocol Class 4 */
		   "NETBLT",      /* 30  Bulk Data Transfer Protocol */ 
		   "MFE-NSP",     /* 31  MFE Network Services Protocol */
		   "MERIT-INP",   /* 32  MERIT Internodal Protocol */
		   "SEP",         /* 33  Sequential Exchange Protocol */
		   "3PC",         /* 34  Third Party Connect Protocol */
		   "IDPR",        /* 35  Inter-Domain Policy Routing Protocol */
		   "XTP",         /* 36  XTP */
		   "DDP",         /* 37  Datagram Delivery Protocol */
		   "IDPR-CMTP",   /* 38  IDPR Control Message Transport Proto */ 
		   "TP++",        /* 39  TP++ Transport Protocol */
		   "IL",          /* 40  IL Transport Protocol */
		   "Prot. 41",    /* 41  Unassigned */
		   "Prot. 42",    /* 42  Unassigned */
		   "Prot. 43",    /* 43  Unassigned */
		   "Prot. 44",    /* 44  Unassigned */
		   "Prot. 45",    /* 45  Unassigned */
		   "Prot. 46",    /* 46  Unassigned */
		   "Prot. 47",    /* 47  Unassigned */
		   "Prot. 48",    /* 48  Unassigned */
		   "Prot. 49",    /* 49  Unassigned */
		   "Prot. 50",    /* 50  Unassigned */
		   "Prot. 51",    /* 51  Unassigned */
		   "Prot. 52",    /* 52  Unassigned */
		   "Prot. 53",    /* 53  Unassigned */
		   "Prot. 54",    /* 54  Unassigned */
		   "Prot. 55",    /* 55  Unassigned */
		   "Prot. 56",    /* 56  Unassigned */
		   "Prot. 57",    /* 57  Unassigned */
		   "Prot. 58",    /* 58  Unassigned */
		   "Prot. 59",    /* 59  Unassigned */
		   "Prot. 60",    /* 60  Unassigned */
		   "Prot. 61",    /* 61  Any host internal protocol */
		   "CFTP",        /* 62  CFTP */
		   "Prot. 63",    /* 63  Any local network */
		   "SAT-EXPAK",   /* 64  SATNET and Backroom EXPAK */
		   "KRYPTOLAN",   /* 65  Kryptolan */
		   "RVD",         /* 66  MIT Remote Virtual Disk Protocol */
		   "IPPC",        /* 67  Internet Pluribus Packet Core */
		   "Prot. 68",    /* 68  Any distributed file system */
		   "SAT-MON",     /* 69  SATNET Monitoring */
		   "VISA",        /* 70  VISA Protocol */
		   "IPCV",        /* 71  Internet Packet Core Utility */
		   "CPNX",        /* 72  Computer Protocol Network Executive */
		   "CPHB",        /* 73  Computer Protocol Heart Beat */
		   "WSN",         /* 74  Wang Span Network */ 
		   "PVP",         /* 75  Packet Video Protocol */
		   "BR-SAT-MON",  /* 76  Backroom SATNET Monitoring */
		   "SUN-ND",      /* 77  SUN ND PROTOCOL-Temporary */
		   "WB-MON",      /* 78  WIDEBAND Monitoring */
		   "WB-EXPAK",    /* 79  WIDEBAND EXPAK */
		   "ISO-IP",      /* 80  ISO Internet Protocol */
		   "VMTP",        /* 81  VMTP */
		   "SECURE-VMTP", /* 82  SECURE-VMTP */
		   "VINES",       /* 83  VINES */
		   "TTP",         /* 84  TTP */
		   "NSFNET-IGP",  /* 85  NSFNET-IGP */
		   "DGP",         /* 86  Dissimilar Gateway Protocol */ 
		   "TCF",         /* 87  TCF */
		   "IGRP",        /* 88  IGRP */
		   "OSPFIGP",     /* 89  OSPFIGP */
		   "Sprite-RPC",  /* 90  Sprite RPC Protocol */
		   "LARP",        /* 91  Locus Address Resolution Protocol */
		   "MTP",         /* 92  Multicast Transport Protocol */
		   "AX.25",       /* 93  AX.25 Frames */
		   "IPIP encap.", /* 94  IP-within-IP Encapsulation Protocol */
		   "MICP",        /* 95  Mobile Internetworking Control Pro. */
		   "AES-SP3-D",   /* 96  AES Security Protocol 3-D */
		   "ETHERIP",     /* 97  Ethernet-within-IP Encapsulation */
		   "ENCAP",       /* 98  Encapsulation Header */
		   "Prot. "       /* Template for 99-255 */
		  };

