/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * Return codes for the packet filter
 *
 * $Id: sf_rc.h,v 1.3 1995/07/13 14:37:44 roland Rel $
 */

#ifndef _SF_RC_H
#define _SF_RC_H

/*
 *      ICMP return codes from sf_check_packet()
 *      See sf_kernel.h for block and accept
 */

#define SF_RC_RNET     -1    /* reject packet with icmp_net_unreachable */
#define SF_RC_RHOST    -2    /* reject packet with icmp_host_unreachable */
#define SF_RC_RPROTO   -3    /* reject packet with icmp_protocol_unreachable */
#define SF_RC_RPORT    -4    /* reject packet with icmp_port_unreachable */

#define SF_RC_MIN      SF_RC_RPORT      /* smallest return code */

#endif
