/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * This file contains all definitions for the TCP reject code.
 *
 * $Id: sf_icmp.h,v 1.0 1996/08/28 14:37:44 robby Rel $
 */

#ifndef _SF_ICMP_H
#define _SF_ICMP_H

#include <linux/if_ether.h>
#include <linux/ip.h>
#include <linux/icmp.h>
#include <net/icmp.h>

extern void icmp_reflect(struct device *dev, struct iphdr *ip, 
                         struct icmphdr *icmp);

extern void send_icmp_error(struct device *dev, 
                            struct iphdr *ip, int type, int code);

#endif
