/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * Routines to send TCP reset for the SF firewall packet filter
 * 
 * $Id: sf_ip.c,v 1.0 1996/08/28 14:37:44 robby Rel $
 *
 */

#include <linux/config.h>
#include <stdio.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/net.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/icmp.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <linux/ip.h>
#include <linux/malloc.h>
#include <linux/timer.h>
#include "sf_kernel.h"
#include "sf_rc.h"
#include "sf_global.h"
#include "sf_filter.h"
#include "sf_control.h"
#include "sf_ip.h"

int ip_mksend(struct rtable * rt, struct sk_buff *skb, __u32 daddr, int len, 
              struct device *dev, __u32 saddr)
{
	int mac = 0;

	skb->dev = dev;
	skb->arp = 1;
	skb->protocol = htons(ETH_P_IP);
	if (dev->hard_header)
	{
		if (rt && dev == rt->rt_dev && rt->rt_hh)
		{
			memcpy(skb_push(skb,dev->hard_header_len),rt->rt_hh->hh_data,dev->hard_header_len);
			if (rt->rt_hh->hh_uptodate)
				return dev->hard_header_len;
			skb->arp = 0;
			skb->raddr = daddr;
			return dev->hard_header_len;
		}
		mac = dev->hard_header(skb, dev, ETH_P_IP, NULL, NULL, len);
		if (mac < 0)
		{
			mac = -mac;
			skb->arp = 0;
			skb->raddr = daddr;	/* next routing address */
		}
	}
	return mac;
}

