/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * sf Firewall protocol names
 *
 * $Id: sf_proto.c,v 1.2 1995/07/13 14:37:44 roland Rel $
 */

#include "sf_proto.h"

/*
 * Protocol names, taken from RFC 1700 and the IANA ftp site.
 * This array is used for displaying the names only and changing it will 
 * merely change the log output.
 * Note! The RFC is updated every year or so.
 */

char *protocol[] ={"Prot. 0",     /*  0  Reserved */
                   "ICMP",        /*  1  Internet Control Message */
		   "IGMP",        /*  2  Internet Group Management */
		   "GGP",         /*  3  Gateway-to-Gateway */
		   "IP encap.",   /*  4  IP in IP (encapsulation) */
		   "ST",          /*  5  Stream */
		   "TCP",         /*  6  Transmission Control */ 
		   "CBT",         /*  7  CBT */ 
		   "EGP",         /*  8  Exterior Gateway Protocol */ 
		   "IGP",         /*  9  Any private interior gateway */
		   "BBN-RCC-MON", /* 10  BBN-RCC-MON BBN RCC Monitoring */
		   "NVP-II",      /* 11  Network Voice Protocol */
		   "PUP",         /* 12  PUP */
		   "ARGUS",       /* 13  ARGUS */
		   "EMCON",       /* 14  EMCON */
		   "XNET",        /* 15  Cross Net Debugger */
		   "CHAOS",       /* 16  Chaos */
		   "UDP",         /* 17  User Datagram */
		   "MUX",         /* 18  Multiplexing */
		   "DCN-MEAS",    /* 19  Measurement Subsystems */
		   "HMP",         /* 20  Host Monitoring */
		   "PRM",         /* 21  Packet Radio Measurement */
		   "XNS-IDP",     /* 22  XEROX NS IDP */
		   "TRUNK-1",     /* 23  Trunk-1 */
		   "TRUNK-2",     /* 24  Trunk-2 */
		   "LEAF-1",      /* 25  Leaf-1 */
		   "LEAF-2",      /* 26  Leaf-2 */
		   "RDP",         /* 27  Reliable Data Protocol */
		   "IRTP",        /* 28  Internet Reliable Transaction */
		   "ISO-TP4",     /* 29  ISO Transport Protocol Class 4 */
		   "NETBLT",      /* 30  Bulk Data Transfer Protocol */ 
		   "MFE-NSP",     /* 31  MFE Network Services Protocol */
		   "MERIT-INP",   /* 32  MERIT Internodal Protocol */
		   "SEP",         /* 33  Sequential Exchange Protocol */
		   "3PC",         /* 34  Third Party Connect Protocol */
		   "IDPR",        /* 35  Inter-Domain Policy Routing Protocol */
		   "XTP",         /* 36  XTP */
		   "DDP",         /* 37  Datagram Delivery Protocol */
		   "IDPR-CMTP",   /* 38  IDPR Control Message Transport Proto */ 
		   "TP++",        /* 39  TP++ Transport Protocol */
		   "IL",          /* 40  IL Transport Protocol */
		   "IPv6",        /* 41  IPv6 */
		   "SDRP",        /* 42  Source Demand Routing Protocol */
		   "IPv6-Route",  /* 43  Routing Header for IPv6 */
		   "IPv6-Frag",   /* 44  Fragment Header for IPv6 */
		   "IDRP",        /* 45  Inter-Domain Routing Protocol */
		   "RSVP",        /* 46  Reservation Protocol */
		   "GRE",         /* 47  General Routing Encapsulation */
		   "MHRP",        /* 48  Mobile Host Routing Protocol */
		   "BNA",         /* 49  BNA */
		   "ESP",         /* 50  Encap Security Payload for IPv6 */
		   "AH",          /* 51  Authentication Header for IPv6 */
		   "I-NLSP",      /* 52  Integrated Net Layer Security */
		   "SWIPE",       /* 53  IP with Encryption */
		   "NARP",        /* 54  NBMA Next Hop Resolution Protocol */
		   "MOBILE",      /* 55  IP Mobility */
		   "TLSP",        /* 56  Transport Layer Security Protocol */
		   "SKIP",        /* 57  SKIP */
		   "IPv6-ICMP",   /* 58  ICMP for IPv6 */
		   "IPv6-NoNxt",  /* 59  No Next Header for IPv6 */
		   "IPv6-Opts",   /* 60  Destination Options for IPv6 */
		   "Prot. 61",    /* 61  Any host internal protocol */
		   "CFTP",        /* 62  CFTP */
		   "Prot. 63",    /* 63  Any local network */
		   "SAT-EXPAK",   /* 64  SATNET and Backroom EXPAK */
		   "KRYPTOLAN",   /* 65  Kryptolan */
		   "RVD",         /* 66  MIT Remote Virtual Disk Protocol */
		   "IPPC",        /* 67  Internet Pluribus Packet Core */
		   "Prot. 68",    /* 68  Any distributed file system */
		   "SAT-MON",     /* 69  SATNET Monitoring */
		   "VISA",        /* 70  VISA Protocol */
		   "IPCV",        /* 71  Internet Packet Core Utility */
		   "CPNX",        /* 72  Computer Protocol Network Executive */
		   "CPHB",        /* 73  Computer Protocol Heart Beat */
		   "WSN",         /* 74  Wang Span Network */ 
		   "PVP",         /* 75  Packet Video Protocol */
		   "BR-SAT-MON",  /* 76  Backroom SATNET Monitoring */
		   "SUN-ND",      /* 77  SUN ND PROTOCOL-Temporary */
		   "WB-MON",      /* 78  WIDEBAND Monitoring */
		   "WB-EXPAK",    /* 79  WIDEBAND EXPAK */
		   "ISO-IP",      /* 80  ISO Internet Protocol */
		   "VMTP",        /* 81  VMTP */
		   "SECURE-VMTP", /* 82  SECURE-VMTP */
		   "VINES",       /* 83  VINES */
		   "TTP",         /* 84  TTP */
		   "NSFNET-IGP",  /* 85  NSFNET-IGP */
		   "DGP",         /* 86  Dissimilar Gateway Protocol */ 
		   "TCF",         /* 87  TCF */
		   "EIGRP",       /* 88  EIGRP */
		   "OSPFIGP",     /* 89  OSPFIGP */
		   "Sprite-RPC",  /* 90  Sprite RPC Protocol */
		   "LARP",        /* 91  Locus Address Resolution Protocol */
		   "MTP",         /* 92  Multicast Transport Protocol */
		   "AX.25",       /* 93  AX.25 Frames */
		   "IPIP encap.", /* 94  IP-within-IP Encapsulation Protocol */
		   "MICP",        /* 95  Mobile Internetworking Control Pro. */
		   "SCC-SP",      /* 96  Semaphore Communications Sec. Pro. */
		   "ETHERIP",     /* 97  Ethernet-within-IP Encapsulation */
		   "ENCAP",       /* 98  Encapsulation Header */
                   "Prot. 99",    /* 99  Any private encryption scheme */
                   "GMTP",        /* 100 GMTP */
                   "IFMP",        /* 101 Ipsilon Flow Management Protocol */
                   "PNNI",        /* 102 PNNI over IP */
                   "PIM",         /* 103 Protocol Independent Multicast */
		   "Prot. "       /* Template for 104-255 */
		  };

/* ICMP Types */
char *icmptype[] = {"echo reply",      /*  0 */
                    "type 1",          /*  1 */
                    "type 2",          /*  2 */
                    "dest. unr.",      /*  3 */
                    "src quench",      /*  4 */
                    "redirect",        /*  5 */
                    "alt. addr.",      /*  6 */
                    "type 7",          /*  7 */
                    "echo req.",       /*  8 */
                    "router adv.",     /*  9 */
	            "router sel.",     /* 10 */
	            "time xceed",      /* 11 */
		    "param probl",     /* 12 */
		    "time req.",       /* 13 */
		    "time reply",      /* 14 */
		    "info req.",       /* 15 */
		    "info reply",      /* 16 */
		    "addr req.",       /* 17 */
		    "addr reply"       /* 18 */
                    "type 19",         /* 19 */
                    "type 20",         /* 20 */
                    "type 21",         /* 21 */
                    "type 22",         /* 22 */
                    "type 23",         /* 23 */
                    "type 24",         /* 24 */
                    "type 25",         /* 25 */
                    "type 26",         /* 26 */
                    "type 27",         /* 27 */
                    "type 28",         /* 28 */
                    "type 29",         /* 29 */
                    "traceroute",      /* 30 */
                    "data cerr",       /* 31 */
                    "mobl redir",      /* 32 */
                    "where r u",       /* 33 */
                    "i am here",       /* 34 */
                    "mobil req.",      /* 35 */
                    "mobil repl",      /* 36 */
                    "dom req.",        /* 37 */
                    "dom reply",       /* 38 */
                    "skip",            /* 39 */
                    "photuris",        /* 40 */
                  };

