/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * Stub routines and procedure variable for the SF firewall packet filter
 * 
 * $Id: sf_stub.c,v 1.5 1995/07/13 14:37:44 roland Rel $
 *
 */

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/net.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/ip.h>
#include <linux/firewall.h>
#include "sf_kernel.h"

int (*sf_fw_chk)(struct iphdr *ip, struct device *rif, int opt) = sf_fw_chk_pass;

int sf_fw_chk_pass(struct iphdr *ip, struct device *rif, int opt)
{
  return FW_ACCEPT; /* accept packet */
}

int sf_fw_chk_block(struct iphdr *ip, struct device *rif, int opt) 
{
  return FW_BLOCK;  /* drop packet */
}

