/*  ----------------------------------------------------------------------
    sf Firewall Software -- a TCP/IP packet filter for Linux
    Copyright (C) 1996 Robert Muchsel and Roland Schmid

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please address all correspondence concerning the software to 
    firewall-bugs@switch.ch.
    ----------------------------------------------------------------------  */

/*
 * Ask the ident server about a tcp connection
 *
 * $Id: sfident.c,v 1.9 1995/08/08 13:09:32 robby Rel $
 */

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <unistd.h>
#include <arpa/inet.h> 
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>

#define AUTH_PORT 113 /* will only be used if getservbyname fails */

void usage(char **argv)
{
  fprintf(stderr, "Usage: %s server port-on-server client port-on-client\n",  
          argv[0]);                                                    
  exit(1);                                                             
}                                                                      

int main(int argc, char **argv)
{
  unsigned long server;
  unsigned long client;
  int serverport, clientport;
  int i, j;
  int fd;
  char *c;
  char buffer[1024], user[1024];
  struct sockaddr_in serv_addr;
  struct sockaddr_in client_addr;
  struct servent *sp;

  if ((argc != 5) || ((argc > 1) && (argv[1][0] == '-')))
    usage(argv);

  serverport =
  clientport = -1;
 
  server = inet_addr(argv[1]);
  sscanf(argv[2], "%i", &serverport);
  client = inet_addr(argv[3]);
  sscanf(argv[4], "%i", &clientport);

  if ((server == 0) || (serverport < 0) || (client == 0) || (clientport < 0))
    usage(argv);

  serv_addr.sin_family        = AF_INET; 
  serv_addr.sin_addr.s_addr   = server;  
  sp = getservbyname("auth", "tcp");           
  if (sp != NULL)                              
    serv_addr.sin_port = sp->s_port;       
  else                                         
    serv_addr.sin_port = htons(AUTH_PORT); 

  client_addr.sin_family      = AF_INET;
  client_addr.sin_addr.s_addr = client;
  client_addr.sin_port        = 0;

  if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    perror("Socket call failed!");
    exit(1);
  }

  /* connect to foreign IDENT server using same address as the TCP 
     connection */ 

  if (bind(fd, (struct sockaddr *) &client_addr, sizeof(client_addr)) < 0) 
    perror("Trying without bind()");

  if ((connect(fd, (struct sockaddr *) &serv_addr, sizeof(serv_addr))) < 0) {
    perror("Cannot connect to server");
    exit(1);
  }

  sprintf(buffer, "%i,%i\n", serverport, clientport);
  write(fd, buffer, sizeof(buffer));
  c = buffer;
  while ((read(fd, c, sizeof(*c)) >= 0) && (*c != '\n') && (strlen(buffer) < 120)) {
    if ((*c < ' ') && (*c != '\t'))
      *c = '.'; /* filter control characters */
    c++; 
  }
  *c = 0;

  if (sscanf(buffer, "%u , %u : USERID :%*[^:]:%255s", &i, &j, user) == 3) 
    printf("User ID: %s\n", user);
  else
    puts(buffer);

  close(fd);

  return 0;
}

  
