#ifndef	_SYS_DPIO_H
#define	_SYS_DPIO_H

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Dialup PPP definitions to communicate to the kernel modules.
 *
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

typedef struct dp_timeo {
    int dt_active,
	dt_active_c,
	dt_active_u,
	dt_waiting,
	dt_failcall;
} dp_timeo_t;

#define	DPT_NTIMEOUTS		(sizeof(dp_timeo_t)/sizeof(int))

#define	DPT_NO_TIMEOUT		(-1)
#define	DPT_DEF_TIMEOUT		(-2)

typedef struct dp_stats {
    int dps_ibytes,
	dps_ipackets,
	dps_ierrors;
    int dps_obytes,
	dps_opackets,
	dps_oerrors;
} dp_stats_t;


/*
 * Bits to OR into the control field of a PPP DLSAP. 
 *
 * DPC_DIAL_REQ		Route packets to this stream when outgoing packets
 *			matching this SAP cannot be sent because the
 *			modem is disconnected and needs dialing.
 * DPC_PROTO_RANGE	Match only on the upper 4 bits of the proto part
 *			of the SAP.  The PPP proto field is 16 bits and
 *			currently defines the following ranges of values:
 *			0XXX	Network Protocol Datagram (e.g. IP, etc)
 *			8XXX	Network Control Protocol (NCP) Datagram
 *			CXXX	Link Control Protocol (LCP) Datagram
 */

#define	DPP_DIAL_REQ	0x0100
#define	DPP_PROTO_MATCH	0x0001
#define	DPP_PROTO_MASK	0xf000


/*
 * Definitions for constructing DLSAP addresses from their componentsT
 */
#define	DP_DLSAP(addr, ctl, proto)	((((ulong)(addr) & 0xff) << 24) | \
					 (((ulong)(ctl)  & 0xff) << 16) | \
					 ((ulong)(proto) & 0xffff))
#define	DP_DLSAP_ADDR(sap)		(((sap) >> 24) & 0xff)
#define	DP_DLSAP_CTL(sap)		(((sap) >> 16) & 0xff)
#define	DP_DLSAP_PROTO(sap)		((sap) & 0xffff)

#define	DP_DIAL_SAP(sap)		((sap) |  DPP_DIAL_REQ)
#define	DP_PROTO_SAP(sap)		((sap) & ~DPP_PROTO_MATCH)

/*
 * Ioctl's that are recognized by the dp device.
 * These are all availble exclusively through the stream ioctl mechanism.
 */
#define	DPIOC		('P' << 8)
#define	DPIOCIFATTACH	(DPIOC|0x01)	/* Attach network device */
#define	DPIOCIFDETACH	(DPIOC|0x02)	/* Detach network device */

#define	DPIOCSTIMEOS	(DPIOC|0x03)	/* Set Timeouts */
#define	DPIOCGTIMEOS	(DPIOC|0x04)	/* Get Timeouts */
#define	DPIOCCALLSTAT	(DPIOC|0x05)	/* Report Call Status */
#define	DPIOCSAPENABLE	(DPIOC|0x06)	/* Enable SAP output */
#define	DPIOCSAPDISABLE	(DPIOC|0x07)	/* Disable SAP output */

#define	DPIOCGIFSTATS	(DPIOC|0x08)	/* Retrieve statistics */

#define	DPIOCSDPDEBUG	(DPIOC|0x0e)	/* Set Debug flag */
#define	DPIOCGDPDEBUG	(DPIOC|0x0f)	/* Get Debug flag */

/*
 * These ioctl's are particular to the Van Jacobson compression module.
 * The dp device will also pass these downstream to get them to a vjc module.
 */
#define	DPIOCSVJCOMP	(DPIOC|0x10)	/* Enable/disable compression */
#define	DPIOCSVJCDEBUG	(DPIOC|0x1e)	/* Set Debug flag */
#define	DPIOCGVJCDEBUG	(DPIOC|0x1f)	/* Get Debug flag */

/*
 * These ioctl's are particular to the PPP Async module.
 * The dp device will also pass these downstream to get them to the ppp_async
 * module.
 */
#define	DPIOCSCOMPAC	(DPIOC|0x20)	
#define	DPIOCSCOMPPROT	(DPIOC|0x21)
#define	DPIOCSMRU	(DPIOC|0x22)
#define	DPIOCGMRU	(DPIOC|0x23)
#define	DPIOCSASYNCMAP	(DPIOC|0x24)
#define	DPIOCGASYNCMAP	(DPIOC|0x25)
#define	DPIOCSASDEBUG	(DPIOC|0x2e)	/* Set Debug flag */
#define	DPIOCGASDEBUG	(DPIOC|0x2f)	/* Get Debug flag */

/*
 * Call status values (for SIOCCALLSTAT)
 */
#define	DP_FAILURE	0	/* Failure to establish modem connection */
#define	DP_SUCCESS	1	/* Connection is established */
#define	DP_IN_PROGRESS	2	/* Connect is being established */
#define	DP_NO_MODEM	3	/* No modem is available */
#define DP_VALID_STATUS(s)	((s) >= 0 && (s) <= 3)

/*
 * Defines for control messages passed between modules.
 */
#define	DP_IF_IERROR	0xe1	/* pppasync -> dp or vjc -> dp */
#define	DP_IF_OERROR	0xe2	/* pppasync -> dp or vjc -> dp */

/*
 * Defines for DLPI messages to the DP device.
 */
#define	DP_MAXDLBUF	PPP_MTU
#define	DP_MAXWAIT	15

/*
 * Path to the DP device
 */
#define	DEVDP			"/dev/dp"

/*
 * A specially defined DLPI primitive to handle inactivity timeouts.
 * There should be a defined way to do this.
 */
typedef struct {
    ulong dl_primitive;
    ulong dl_signal;
} dl_signal_ind_t;

#define	DL_SIGNAL_IND		0x1001

#define	DL_SIGNAL_IND_SIZE	sizeof (dl_signal_ind_t)



#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_DPIO_H */
