#define TIME_COUNT 5.0
#include <stdio.h>
#include <string.h>

int length;

main(argc, argv)
	int argc;
	char **argv;
{
	char line[256], *ptr;

	length = atoi(*++argv);
	fprintf(stdout, "length = %d bytes\n", length);
	fprintf(stdout, "#################################################################################\n");

	while(1) {
		while (1) {
			if (fgets(line, sizeof line, stdin) == NULL) {
				exit(1);
			}
			strtok(line, "\t");
			if ((ptr = strtok(NULL, "\t\n")) != NULL && strcmp(ptr, "hsi_poll: enter") == 0) {
				break;
			}
		}

		while (1) {
			if (get_elapsed_time("hsi_poll", 0) < 0) {
				break;
			}
			fprintf(stdout, "---------------------------------------------------------------------------------\n");
			if (fgets(line, sizeof line, stdin) == NULL) {
				exit(1);
			}
			strtok(line, "\t");
			if ((ptr = strtok(NULL, "\t\n")) == NULL || strcmp(ptr, "hsi_poll: enter") != 0) {
				break;
			}
		}

		fprintf(stdout, "#################################################################################\n");
	}
}

get_elapsed_time(event, level)
	char *event;
	int level;
{
	char line[256], *next_event;
	int enter_sec, enter_usec, enter_count;
	int exit_sec, exit_usec, exit_count;
	int elapsed_count;
	double bit_rate;
	int timer_count = 0, lower_timer_count;

	if (fgets(line, sizeof line, stdin) == NULL) {
		exit(2);
	}
	if (sscanf(line, "%*s %x %x %x", &enter_sec, &enter_usec, &enter_count) != 3) {
		return(-1);
	}
	if (fgets(line, sizeof line, stdin) == 0) {
		exit(3);
	}
	while (1) {
		if (fgets(line, sizeof line, stdin) == NULL) {
			exit(4);
		}
		strtok(line, "\t");
		if ((next_event = strtok(NULL, ":")) == NULL) {
			return(-2);
		}
 		if (strcmp(next_event, event) == 0) {
			break;
		} else {
			if ((lower_timer_count = get_elapsed_time(next_event, level + 1)) >= 0) {
				timer_count += lower_timer_count;
				++timer_count;
			} else {
				return(lower_timer_count);
			}
		}
	}
	if (fgets(line, sizeof line, stdin) == NULL) {
		exit(5);
	}
	if (sscanf(line, "%*s %x %x %x", &exit_sec, &exit_usec, &exit_count) != 3) {
		return(-3);
	}
	if (strcmp(event, "TIME") == 0) {
		elapsed_count = (exit_count - enter_count) >> 10;
		fprintf(stdout, "%40s[%d]   %7d usec (uncorrected)\n", event, level, elapsed_count);
	}
	elapsed_count = ((exit_count - enter_count) >> 10) - (timer_count + 0.5) * TIME_COUNT;
	fprintf(stdout, "%40s[%d]   %7d usec\n", event, level, elapsed_count);
	if (level == 0) {
		bit_rate = (double)(length * 8) / (double)elapsed_count;
		fprintf(stdout, "%40s[%d]   %7.3f Mbps\n", event, level, bit_rate);
	}
	if (fgets(line, sizeof line, stdin) == NULL) {
		exit(6);
	}
	return(timer_count);
}
