/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jde.wizards.ClassRegistry;
import jde.wizards.NameFactory;

public class Signature {
    private Method method;
    private Class[] parameters;
    private Class[] exceptions;
    private Class return_value;
    private Class declaring;
    private ClassRegistry registry;
    private boolean truncate;
    private boolean see;

    public Signature(Method method, ClassRegistry classRegistry) {
        this(method, classRegistry, true);
    }

    public Signature(Method method, ClassRegistry classRegistry, boolean bl) {
        this(method, classRegistry, true, false);
    }

    public Signature(Method method, ClassRegistry classRegistry, boolean bl, boolean bl2) {
        this.method = method;
        this.registry = classRegistry;
        this.truncate = bl;
        this.see = bl2;
        this.parameters = this.method.getParameterTypes();
        this.exceptions = this.method.getExceptionTypes();
        this.return_value = this.method.getReturnType();
        this.declaring = this.method.getDeclaringClass();
        this.register();
    }

    public void setTruncating(boolean bl) {
        this.truncate = bl;
    }

    public void setRegistry(ClassRegistry classRegistry) {
        this.registry = classRegistry;
    }

    public Class getDeclaringClass() {
        return this.declaring;
    }

    public String toJavaDoc() {
        NameFactory nameFactory = this.registry.getNameFactory();
        StringBuffer stringBuffer = new StringBuffer("/**\n *\n *");
        int n = 0;
        while (n < this.parameters.length) {
            stringBuffer.append(" @param " + nameFactory.getParameterName(this.parameters[n], n + 1, this.parameters.length) + " <description>\n *");
            ++n;
        }
        if (!"void".equals(this.return_value.getName())) {
            stringBuffer.append(" @return <description>\n *");
        }
        int n2 = 0;
        while (n2 < this.exceptions.length) {
            stringBuffer.append(" @exception " + this.exceptions[n2].getName() + " <description>\n *");
            ++n2;
        }
        if (this.see) {
            stringBuffer.append(" @see ");
            stringBuffer.append(this.method.getDeclaringClass().getName());
            stringBuffer.append('#');
            stringBuffer.append(this.method.getName());
            stringBuffer.append('(');
            stringBuffer.append(this.getParameters(this.method.getParameterTypes(), false));
            stringBuffer.append(')');
            stringBuffer.append("\n *");
        }
        stringBuffer.append("/");
        return stringBuffer.toString();
    }

    public String toString() {
        String string = this.getModifiers();
        String string2 = this.baseName(this.return_value);
        String string3 = this.method.getName();
        String string4 = this.getParameters(this.parameters);
        String string5 = this.getExceptions(this.exceptions);
        return string + " " + string2 + " " + string3 + "(" + string4 + ")" + string5;
    }

    public boolean paramsEqual(Class[] classArray) {
        boolean bl;
        int n = this.parameters.length;
        boolean bl2 = bl = classArray.length == n;
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                if (!classArray[n2].equals(this.parameters[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object instanceof Signature) {
            Signature signature = (Signature)object;
            return this.method.getName().equals(signature.getMethod().getName()) && this.paramsEqual(signature.getMethod().getParameterTypes());
        }
        return false;
    }

    public Method getMethod() {
        return this.method;
    }

    public final String baseName(Class clazz) {
        int n;
        String string = null;
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n2 = 0;
                while (clazz2.isArray()) {
                    clazz2 = clazz2.getComponentType();
                    ++n2;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(clazz2.getName());
                int n3 = 0;
                while (n3 < n2) {
                    stringBuffer.append("[]");
                    ++n3;
                }
                string = stringBuffer.toString();
            }
            catch (Throwable throwable) {
                string = clazz.getName();
            }
        } else {
            string = clazz.getName();
        }
        if (this.truncate && (n = string.lastIndexOf(46)) > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    private final String getExceptions(Class[] classArray) {
        if (null == classArray || classArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(" throws ");
        int n = 0;
        while (n < classArray.length) {
            String string = this.baseName(classArray[n]);
            stringBuffer.append(string);
            if (n < classArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public final String getParameters(Class[] classArray) {
        return this.getParameters(classArray, true);
    }

    public final String getParameters(Class[] classArray, boolean bl) {
        if (null == classArray || classArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        NameFactory nameFactory = this.registry.getNameFactory();
        int n = 0;
        while (n < classArray.length) {
            String string = this.baseName(classArray[n]);
            String string2 = nameFactory.getParameterName(classArray[n], n + 1, classArray.length);
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
            if (n < classArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public final String getParameterNames(Class[] classArray) {
        if (null == classArray || classArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        NameFactory nameFactory = this.registry.getNameFactory();
        int n = 0;
        while (n < classArray.length) {
            String string = this.baseName(classArray[n]);
            String string2 = nameFactory.getParameterName(classArray[n], n + 1, classArray.length);
            stringBuffer.append(string2);
            if (n < classArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private final String getModifiers() {
        StringBuffer stringBuffer = new StringBuffer("public");
        int n = this.method.getModifiers();
        if (Modifier.isSynchronized(n)) {
            stringBuffer.append(" synchronized");
        }
        return stringBuffer.toString();
    }

    private final void register() {
        if (null != this.registry) {
            this.registry.registerImport(this.declaring);
            this.registry.registerImport(this.return_value);
            int n = 0;
            while (n < this.parameters.length) {
                this.registry.registerImport(this.parameters[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.exceptions.length) {
                this.registry.registerImport(this.exceptions[n2]);
                ++n2;
            }
        }
    }
}

