/* dialog.c
 * The dialog boxes have a customized translation table.  This file contains
 * the new functions mentioned in that table.
 *
 * Peter Webb, Summer 1990.
 */

/* X include files */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

/* Widget include files */

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Dialog.h>

/* Package include files */

#include "types.h"      /* Package-wide type definitions */
#include "error.h"      /* Error codes */
#include "extern.h"     /* External routines and global variables */
#include "reformat.h"   /* Package-wide contants */
#include "window.h"

#include <stdio.h>

/* Static variables */

static Direction searchDir = Forward;


#ifdef notdef
static XComposeStatus compose_status = {NULL, 0};

/* The text field of a dialog box widget is fixed in length, and thus when a
 * new character is inserted, it may be necessary to move the text (scroll it
 * to the left, obscuring some of the leftmost characters) so that the insert
 * point never moves to the right of the dialog box border.  A dialog box
 * never has more than one line, which simplifies matters (don't have to worry
 * about filling margins, for example).
 *
 * This code is based upon the InsertChar routine in the Athena Widget Set (R4)
 * (see TextAction.c).
 */

void DialogInsertChar(w, event)
  Widget w;
  Xevent *event;
{ 
  XawTextBlock text;
  TextWidget ctx = (TextWidget) w;
  char *ptr, strbuf[LINE_SIZE];
  int count, error;
  KeySym keysym;

/* If the text in the event is of zero-length, don't do anything. */

  if ( (text.length = XLookupString (&event->xkey, strbuf, LINE_SIZE,
                               &keysym, &compose_status)) == 0)
    return;

/* Allocate space for the new string, and copy it into the new space */

  text.ptr = ptr = XtMalloc(sizeof(char) * text.length * ctx->text.mult);
  for (count = 0 ; count < ctx->text.mult ; count++)
    {
      strncpy(ptr, strbuf, text.length);
      ptr += text.length;
    }

/* Now, check to see if the length of the string exceeds the width of the
 * dialog box.  If it does, only display the rightmost n characters of the
 * string, where n is the maximum number that will fit into the text field.
 */

  if (0)
    {
/* Get the current text */

      error = XawTextReplace(ctx, ctx->text.insertPos, ctx->text.insertPos,
			     &text);
    }
  else  /* Insert the character into the text field */
    {

/* Set up the rest of the text block */

      text.length = text.length * ctx->text.mult;
      text.firstPos = 0;
      text.format = FMT8BIT;

/* Replace the text in the text field with the new text */

      error = XawTextReplace(ctx, ctx->text.insertPos, ctx->text.insertPos,
			     &text);
    }

  if (error == XawEditDone)  /* The new text was successfully added */
    {
    }
  else XBell(XtDisplay(ctx), 50);

/* Free the allocated space */

  XtFree(text.ptr);
}
#endif

/* New action for the Dialog boxes.  Called when carriage return or line
 * feed occurs in the text input window.
 */

void DialogNewString(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  Arg args[MAX_ARGS];
  String str;
  char *name;
  Widget text, text_src;
  XawTextPosition pos, new_pos;
  XawTextBlock block;
  int num;

/* Get the XtNstring resource */

  XtSetArg(args[0], XtNstring, &str);
  XtGetValues(w, args, 1);

/* Get the name of the parent */

  name = XtName(XtParent(w));

/* The parent of the text widget indicates in which dialog box the event
 * occurred.  The dialog box indicates what action should be taken.
 */

  if (strcmp(name, FILENAME) == 0)  /* New output file name */
    {
      printf("New output file:\n  %s\n", str);
    }
  else if (strcmp(name, FROM_BOX) == 0) /* New input dir. */
    {
      printf("New input directory:\n  %s\n", str);
    }
  else if (strcmp(name, TO_BOX) == 0) /* New output directory */
    {
      printf("New output directory:\n  %s\n", str);
    }
  else if (strcmp(name, SEARCH_BOX) == 0)  /*  Search box in help window */
    {

/* Get the pointer to the TextSource object containted in the text widget */

      text = XtNameToWidget(XtParent(XtParent(w)), HELP_TEXT);

/* Construct a TextBlock containing the text to search for */

      block.ptr = str;
      block.length = strlen(block.ptr);
      block.firstPos = 0;
      block.format = FMT8BIT;

      new_pos = XawTextSearch(text, /* pos, */
			      (searchDir == Forward ? XawsdRight : XawsdLeft),
			      &block);

      if (new_pos != XawTextSearchError)
	{

/* Set the position of the insert cursor.  Since the cursor is always forced 
 * to be on the screen, this effectively scrolls the screen to the new 
 * position.
 */

          XawTextSetInsertionPoint(text, new_pos);
	}
      else /* Ring the bell */
	XBell(display, 100);
    } /* End if */
}

/* When the mouse cursor enters the text widget of a dialog box, highlight
 * the widget by doubling the width of its border.
 */

void DialogFocusIn(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  int arg_num;
  Arg arg_list[2];
  Dimension width;
  XEvent usr_event;

/* Get the old border width */

  arg_num = 0;
  XtSetArg(arg_list[arg_num], XtNborderWidth, &width); arg_num++;
  XtGetValues(w, arg_list, arg_num);

/* Set the new border width */

  width *= 2;
  arg_num = 0;
  XtSetArg(arg_list[arg_num], XtNborderWidth, width); arg_num++;
  XtSetValues(w, arg_list, arg_num);

/* Call the expose routine of the superclass */

  usr_event.type = Expose;
  XSendEvent(display, XtWindow(w), True, ExposureMask, &usr_event);

}

/* When the mouse cursor exits the text widget of a dialog box, unhighlight
 * the widget by halving the width of its border.
 */

void DialogFocusOut(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  int arg_num;
  Arg arg_list[2];
  Dimension width;
  XEvent usr_event;

/* Get the old border width */

  arg_num = 0;
  XtSetArg(arg_list[arg_num], XtNborderWidth, &width); arg_num++;
  XtGetValues(w, arg_list, arg_num);

/* Set the new border width */

  width /= 2;
  arg_num = 0;
  XtSetArg(arg_list[arg_num], XtNborderWidth, width); arg_num++;
  XtSetValues(w, arg_list, arg_num);

/* Call the expose routine of the superclass */

  usr_event.type = Expose;
  XSendEvent(display, XtWindow(w), True, ExposureMask, &usr_event);
}
