/* sun2ri8.h
 * Contains type definitions for sun raster file structures.
 * Peter Webb, Fall 1990red[ras_maplength/3],green[],blue[]
 */

/* After the defintion in the SUN Pixrect Manual.  Only the names have been
 * changed (to protect the innocent?)
 */

typedef struct sun_raster {
  int magic;  
  int width;
  int height;
  int depth;
  int length;
  int type;
  int maptype;
  int maplen;
} SunRasterInfo;

/* Magic number identifying a SUN raster file */

#define MAGIC 0x59a66a95

/* Sun supported raster types - taken from rasterfile.h */

#define RT_OLD           0
#define RT_STANDARD      1
#define RT_BYTE_ENCODED  2  /* Run-length encoding */
#define RT_EXPERIMENTAL  0xffff

/* Raster maptypes - also taken from rasterfile.h */

#define RMT_RAW        2  /* Raw bytes */
#define RMT_NONE       0  /* No colormap, maplen == 0 */
#define RMT_EQUAL_RGB  1  /* red[maplength/3],green[],blue[] */

/* Note that the length of each line of the image is rounded to the nearest 
 * multiple of 16 bits.
 */
