
#include "xhips.h"

struct lbent *lbtable=NULL;
struct lbrange lbrtab[LBCOLORS];
static XImage *pfrm; /* psuedo frame buffer.  perverse, but expedient */

/***************************************/

void polyhist_eval()
{
  struct plist *pltr;
  struct pbstore *pbtr;
  unsigned char *tmp;
  int x=0,y=0;
  XPoint pents[50];
  int n,npts;

  clear_info();
  npts=getncp();
  if (npts==0)
    return;
  if (pfrm!=NULL) {
    XDestroyImage(pfrm);
  }
  /* create a zero'ed XImage which will just store points where the polygon
     is. */
  tmp=(unsigned char *) calloc(1,(base->width*base->height));
  pfrm=XCreateImage(display, (Visual *) winv->visual, winv->depth, ZPixmap,
		    0, tmp, base->width, base->height, 8, 0);
  /* move all points from cpl into transient flist entry. */
  dcross_flush(&curphist->ptlist);
  n=npts;
  pltr=curphist->ptlist;
  line_setup(xid,*base);
  curphist->pstore=(struct pbstore *) malloc(sizeof(struct pbstore));
  curphist->pstore->next=curphist->pstore->prev=NULL;
  pbtr=curphist->pstore;
  draw_polygon(pents,npts,pbtr,pltr);
  drawpts(pfrm, curphist->pstore, standout);
  for (n=0; n < npts; n++) {
    x+=pents[n].x;
    y+=pents[n].y;
  }
  flood_fill(x/n, y/n);
  if (pfrm!=NULL) {
    XDestroyImage(pfrm);
  }
  fl_add(*curphist);
  fent=fltail;
  do_hist();
}
/***********************************************/

draw_polygon(pents,npts,pbtr,pltr)
XPoint *pents;
int npts;
struct pbstore *pbtr;
struct plist *pltr;
{
  int n=npts;

  while (n>1) {
    pents[npts-n].x=pltr->pt.x;
    pents[npts-n].y=pltr->pt.y;
#ifdef DEBUG
    printf("pents[%d].x=%d .y=%d.\n",npts-n,pents[npts-n].x,
	   pents[npts-n].y);
#endif
    line_spnt(pltr->pt);
    line_epnt(pltr->next->pt);
    pbtr->len=line_len();
    pbtr->points=(struct pval *) malloc(sizeof(struct pval)*pbtr->len);
    line_done(pbtr->points);
    pbtr->next=(struct pbstore *) malloc(sizeof(struct pbstore));
    pbtr->next->prev=pbtr;
    pbtr->next->next=NULL;
    pbtr=pbtr->next;
    pltr=pltr->next;
    n--;
  }
  pents[npts-1].x=pltr->pt.x;
  pents[npts-1].y=pltr->pt.y;
  pents[npts].x=curphist->ptlist->pt.x;
  pents[npts].y=curphist->ptlist->pt.y;
  line_spnt(pents[npts-1]);
  line_epnt(pents[npts]);
  pbtr->len=line_len();
  pbtr->points=(struct pval *) malloc(sizeof(struct pval)*pbtr->len);
  line_done(pbtr->points);

}

/***********************************************/

drawpts(img,pvec,color)
XImage *img;
struct pbstore *pvec;
unsigned long color;
{
  int i;
  struct pbstore *tr;

  for (tr=pvec; tr!=NULL; tr=tr->next) {
    for (i=0; i < tr->len; i++) {
      XPutPixel(img, tr->points[i].pt.x,tr->points[i].pt.y, color);
    }
  }
}
/***********************************************/

void
dcross(win,event, arg, type)
     Xv_Window win;
     Event *event;
     Notify_arg arg;
     Notify_event_type type;
{
 struct plist ept;
 unsigned long x, y;
 XGCValues gcval;


 if (base_ras==NULL)
   return;
 if (((int) event_x(event) < 0) || ((int) event_y(event) < 0))
   return;
 if (((int) event_x(event) >= base_ras->cols) ||
     ((int) event_y(event) >= base_ras->rows))
   return;
  if (event_is_down(event) && event_id(event) == BUT(1)) {
    if ((ncp<plim) || (plim==0)) {
      ept.pt.x=(short) event_x(event);
      ept.pt.y=(short) event_y(event);
      cbget(base,&ept.cb,ept.pt);
      gcval.foreground=standout;
      XChangeGC(display, gc, GCForeground, &gcval);
      XDrawLine(display, xid, gc, ept.cb.top.x,
                ept.cb.top.y, ept.cb.top.x,
                ept.cb.top.y+ept.cb.cht);
      XDrawLine(display, xid, gc, ept.cb.left.x,
                ept.cb.left.y, ept.cb.left.x + ept.cb.cwt,
                ept.cb.left.y);
      cpladd(&ept);
    }
#ifdef DEBUG
    printf("ncp==%d, plim==%d\n",ncp,plim);
#endif
  }
  if (event_is_down(event) && event_id(event) == BUT(2)) {
    ept.pt.x=(short) event_x(event);
    ept.pt.y=(short) event_y(event);
    if ((int) pfind(&ept) > 0) {
      /* delete this point and let the user add a new one. */
      pdel(&ept);
    }
  }
#ifdef BROKE
  if (event_is_down(event) && event_id(event)==LOC_DRAG) {
    ept.pt.x=(short) event_x(event);
    ept.pt.y=(short) event_y(event);
    if ( (pfind(&ept) > 0) || (ncp<plim)) {
      if (pfind(&ept) > 0)
        pdel(ept);
      gcval.foreground=standout;
      XChangeGC(display, gc, GCForeground, &gcval);
      XDrawLine(display, xid, gc, ept.cb.top.x,
                ept.cb.top.y, ept.cb.top.x,
                ept.cb.top.y+ept.cb.cht);
      XDrawLine(display, xid, gc, ept.cb.left.x,
                ept.cb.left.y, ept.cb.left.x + ept.cb.cwt,
                ept.cb.left.y);
      cpladd(&ept);
    }
  }
#endif
  notify_next_event_func(win, event, arg, type);
}


/***********************************************/

redraw(xid,bst)
     XID xid;
     struct cbstore bst;
{
  /* should eventually add routines to checkand make sure no collisions with
     other crosses occur, but WE'LL WAIT....*/
  register XGCValues gcval;
  register int i;
  register int x,y;

#ifdef DEBUG
  gcval.foreground=standout;
  XChangeGC(display, gc, GCForeground, &gcval);
  XDrawLine(display, xid, gc, 0, 0, 20, 20);
#endif

  x=bst.top.x;
  y=bst.top.y;
  while (y <= (bst.top.y+bst.cht)) {
    gcval.foreground=bst.vvals[(y-bst.top.y)];
    XChangeGC(display, gc, GCForeground, &gcval);
    XDrawPoint(display, xid, gc, x,y);
    y++;
  }
  x=bst.left.x;
  y=bst.left.y;
  while (x <= (bst.left.x+bst.cwt)) {
    gcval.foreground=bst.hvals[(x-bst.left.x)];
    XChangeGC(display, gc, GCForeground, &gcval);
    XDrawPoint(display, xid, gc, x, y);
    x++;
  }
}

/***********************************************/
pdel(pnt)
struct plist *pnt;
{
  if (pnt->prev!=NULL) {
    if (cpltail==pnt->prev->next)
      cpltail=pnt->prev;
    free(pnt->prev->next);
    pnt->prev->next=pnt->next;
    if (pnt->next!=NULL)
      pnt->next->prev=pnt->prev;
  }
  else {
    if (cplhead==cpltail)
      cpltail=NULL;
    free(cplhead);
    cplhead=pnt->next;
    if (pnt->next!=NULL)
      pnt->next->prev=NULL;
  }
  redraw(xid, pnt->cb);
  ncp--;
  if (pt_del_fn!=NULL)
    (*pt_del_fn)();
}
