/*
 * view_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `view.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "view_ui.h"

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

void
main(argc, argv)
	int		argc;
	char		**argv;
{
	view_win_objects	*view_win;
	
	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);
	INSTANCE = xv_unique_key();
	
	/*
	 * Initialize user interface components.
	 */
	view_win = view_win_objects_initialize(NULL, NULL);
	
	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(view_win->win);
	exit(0);
}

#endif

/*
 * Event callback function for `canvas'.
 */
Notify_value
disp_event_proc(win, event, arg, type)
	Xv_window	win;
	Event		*event;
	Notify_arg	arg;
	Notify_event_type type;
{
	view_win_objects	*ip = (view_win_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "view: disp_event_proc: event %d\n", event_id(event));
	
	if (event_action(event) == ACTION_DRAG_LOAD) {
		char	name[MAXPATHLEN];

		if (gdd_get_drag_name(win, name) != -1) {
			fprintf(stderr, "view: disp_event_proc: load %s\n", name);
		}
	} else if (event_action(event) == ACTION_MENU && event_is_down(event)) {
		Menu	menu = (Menu) xv_get(win, WIN_MENU);

		if (menu)
			menu_show(menu, win, event, 0);
	}
	return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*
 * Repaint callback function for `canvas'.
 */
void
image_repaint_proc(canvas, paint_window, display, xid, rects)
	Canvas		canvas;
	Xv_window	paint_window;
	Display		*display;
	Window		xid;
	Xv_xrectlist	*rects;
{
	fputs("view: image_repaint_proc\n", stderr);
}

