/* normfrag.c      Distribution 1.1   89/3/30   Scry */

/*   The Scry system is copyright (C) 1988, 1989, Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof.     */

/* normfrag.c
 * Calculate normals in the marching cubes.
 * Looks abominable.
 */
for(q = 0; q < 3; q++) {
#ifndef VAX
    if((f[q] = IF(s[q])) != (c[q] = IC(s[q]))) {
#else
    f[q] = IF(s[q]) ;
    c[q] = IC(s[q]) ;
    if (f[q] != c[q])
    {
#endif
	b[q] = F(s[q]); u[q] = C(s[q]);
	if(f[q] <= 0) fl[q] = 0; else fl[q] = f[q]-1;
	if(c[q] <= 0) cl[q] = 0; else cl[q] = c[q]-1;
	if(f[q] >= t[q]) fg[q] = t[q]; else fg[q] = f[q]+1;
	if(c[q] >= t[q]) cg[q] = t[q]; else cg[q] = c[q]+1;
	if(f[q] < 0) f[q] = 0; if(c[q] < 0) c[q] = 0;
	if(c[q] >= t[q]) c[q] = f[q] = t[q];
    } else {
	if(f[q] <= 0) fl[q] = 0; else fl[q] = f[q]-1;
	if(f[q] >= t[q]) fg[q] = t[q]; else fg[q] = f[q]+1;
    }
}
/* added 11/90 by BLT to prevent crash ! */
if(f[EX] < 0)
   f[EX] = 0;
if(f[EY] < 0)
   f[EY] = 0;
if(f[EZ] < 0)
   f[EZ] = 0;

if(f[EX] == c[EX])
     s[EX] = normx[num_edges] =
	 array[fg[EX]][f[EY]][f[EZ]] - array[fl[EX]][f[EY]][f[EZ]];
else
    s[EX] = normx[num_edges] =
    ((array[fg[EX]][f[EY]][f[EZ]] - array[fl[EX]][f[EY]][f[EZ]])*
     (s[EX] - b[EX]) + (u[EX] - s[EX])*
     (array[cg[EX]][c[EY]][c[EZ]] - array[cl[EX]][c[EY]][c[EZ]]));
if(f[EY] == c[EY])
     s[EY] = normy[num_edges] =
	 array[f[EX]][fg[EY]][f[EZ]] - array[f[EX]][fl[EY]][f[EZ]];
else
    s[EY] = normy[num_edges] =
    ((array[f[EX]][fg[EY]][f[EZ]] - array[f[EX]][fl[EY]][f[EZ]])*
     (s[EY] - b[EY]) + (u[EY] - s[EY])*
     (array[c[EX]][cg[EY]][c[EZ]] - array[c[EX]][cl[EY]][c[EZ]]));
if(f[EZ] == c[EZ])
     s[EZ] = normz[num_edges] =
	 array[f[EX]][f[EY]][fg[EZ]] - array[f[EX]][f[EY]][fl[EZ]];
else
    s[EZ] = normz[num_edges] =
    ((array[f[EX]][f[EY]][fg[EZ]] - array[f[EX]][f[EY]][fl[EZ]])*
     (s[EZ] - b[EZ]) + (u[EZ] - s[EZ])*
     (array[c[EX]][c[EY]][cg[EZ]] - array[c[EX]][c[EY]][cl[EZ]]));
mag = sqrt(s[EX]*s[EX] + s[EY]*s[EY] + s[EZ]*s[EZ]);
normx[num_edges] /= mag;
normy[num_edges] /= mag;
normz[num_edges] /= mag;
