/* xvdisplay.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <math.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_limits.h>
#include "xvwin.h"
#include "Xanima_ui.h"
#include "image_ui.h"
#include <xview/cms.h>
#include <xview/screen.h>
#include <xview/svrimage.h>


/* image_init:  initialize Xanima display window
   anima_repaint:  repaint procedure
   make_dynamic_cms_colormap:  set up dynamic Xview color map
   display_frame:  display an Anima frame */


unsigned char S_map[S_MAX_COL_SIZE][3] ;	/* color map */
int S_mapnum ;			/* number of entries in color map */
int S_maxcol = S_MAX_COL_DISPLAY ;	/* maximum number of entries in color map */

struct image_stuff S_image_info ;	/* image display information */

image_win_objects *image_win;	/* image display window */
extern Xanima_control_objects *Xanima_control;	/* Xanima control panel */
int screen ;
XID image_xid ;

unsigned long *colors ;		/* used in remapping colors to X indices */

XImage *xim = NULL ;
unsigned char *S_image_mem = NULL;

Display *display ;
GC gc ;
XVisualInfo *winv ;

unsigned char red[S_MAX_COL_SIZE],green[S_MAX_COL_SIZE],blue[S_MAX_COL_SIZE] ;
Xv_cmsdata cms_data ;

int S_zoom_changed ;		/* have zoomed or unzommed */

static char anima_format[80] ;	/* many map or one map Anima file */




/* initialize Xanima display window */

void
image_init(owner)

Xv_opaque owner;

{
    void make_dynamic_cms_colormap();
    int i ;

    image_win = image_win_objects_initialize(NULL, owner);
    xv_set(image_win->win,
	       OPENWIN_AUTO_CLEAR, TRUE,
	       NULL) ;
    make_dynamic_cms_colormap(&cms_data);
    xv_set(image_win->anima_canvas,
	       WIN_CMS_NAME,"xanima",
	       WIN_CMS_DATA,&cms_data,
	       0) ;
    colors = (unsigned long *) xv_get(image_win->anima_canvas, WIN_X_COLOR_INDICES);

    display = (Display *) xv_get(owner, XV_DISPLAY);
    screen = DefaultScreen(display);
    gc = DefaultGC(display,screen);
    XSetForeground(display,gc,WhitePixel(display,screen)) ;
    image_xid = (XID) xv_get(canvas_paint_window(image_win->anima_canvas), XV_XID);

    {
	Atom  catom ;
	Window frame_xid ;

        frame_xid = xv_get(image_win->win,XV_XID) ;
	catom = XInternAtom (display,"WM_COLORMAP_WINDOWS",False);
	XChangeProperty(display,frame_xid,catom,XA_WINDOW,32,
		  PropModeAppend, &image_xid, 1) ;
    }

    winv = (XVisualInfo *) malloc(sizeof(XVisualInfo));
    if ((int) XMatchVisualInfo(display, screen,
                               XDisplayPlanes(display, screen),
                               PseudoColor, winv) == 0)
    {
        fprintf(stderr, "unable to find correct visual \n");
        exit(0);
    }

    S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
    S_image_mem = (unsigned char *) calloc(S_image_info.s_height*S_image_info.s_width,sizeof(char)) ;
    xim = XCreateImage(display,
		XDefaultVisual(display,screen),
		8, ZPixmap, 0,
		S_image_mem,
		S_image_info.s_width,S_image_info.s_height,
		16,0) ;
    S_image_info.compression = S_CCC ;
}




/*
 * Repaint callback function for `anima_canvas'.
 */
void
anima_repaint(canvas, paint_window, rects)
	Canvas		canvas;
	Xv_window	paint_window;
	Rectlist	*rects;
{
#ifdef DEBUG
	fputs("image: anima_repaint\n", stderr);
#endif
        if (!S_dont_repaint)
	       XPutImage(display,image_xid,
	                 gc,xim,0,0,0,0,S_image_info.s_width,S_image_info.s_height) ;
}




/* set up dynamic Xview color map */

void
make_dynamic_cms_colormap(cms_data)
    Xv_cmsdata *cms_data;
{

    cms_data->type = XV_DYNAMIC_CMS;
    cms_data->size = S_maxcol;
    cms_data->rgb_count = S_maxcol;
    cms_data->index = 0;
    cms_data->red = red;
    cms_data->green = green;
    cms_data->blue = blue;
}




/* display an Anima frame */

display_frame()
{
    register int i, j;
    char s[12];			/* current frame number string */
    int height, width ;
    int repaint_status ;
    
        /* Figure out where to get the next frame from. */
    if(S_avars.start)
        S_avars.current = 0;
    else if(S_avars.search)
    {
        xv_set(Xanima_control->frame_text, PANEL_VALUE, "", 0);
        xv_set(Xanima_control->control,
                   PANEL_CARET_ITEM, Xanima_control->frame_text,
                   0);
        S_avars.stop = TRUE;
        S_avars.advance = FALSE;
        S_avars.search = FALSE;
    }
	/* go back to beginning */
    else if((S_avars.current == S_avars.frame.last) &&
		  S_avars.direction == S_FORWARD)
    {
        S_avars.current = 0 ;
        S_avars.frame.last = S_anima_count - 1;
    }
    else
    {
        if(S_avars.direction == S_BACKWARD)
        {
            if (S_avars.current > 0)
                S_avars.current--;
            else
                S_avars.current = S_avars.frame.last ;
        }
        else if(S_avars.current < S_anima_count-1)
            S_avars.current++;
        if(S_avars.advance)
        {
            S_avars.stop = TRUE;
            S_avars.advance = FALSE;
        }
        else
            ;
    }
	/* seek to current Anima frame */
    fseek(S_anima_file, S_a_index[S_avars.current].offset, 0);

	/* if header for each frame format, read header */
    if ((anima_format[0] == 'm') || S_avars.start || (S_avars.current == 0))
    {
        if(!iff_read_header(S_anima_file, &S_image_info, &height, &width, anima_format))
	    fprintf(stderr,"iff_read_header died\n");

        if ((width > S_MAX_WINSERV_WIDTH) ||
	   (height > S_MAX_WINSERV_HEIGHT) ||
	   (width < 1) || (height < 1))
	   {
	       fprintf (stderr,"illegal sized image\n") ;
	       exit(0) ;
	   }
		/* if frame different size */
        if ((((width != S_image_info.s_width) ||
	    (height != S_image_info.s_height))) && S_avars.start)
        {
	    repaint_status = S_dont_repaint ;
	    S_dont_repaint = 1 ;
#ifdef MESSAGES
	    fprintf (stderr, "new height, width = %d %d\n",height,width) ;
#endif
	    S_do_zoom = 0 ;
	    S_zoom_changed = 0 ;
		/* reset window size */
	    S_image_info.s_width = width ;
	    S_image_info.s_height = height ;
            (void) xv_set(image_win->win,
		    XV_WIDTH, S_image_info.s_width,
		    XV_HEIGHT, S_image_info.s_height,
		    NULL) ;
	    (void) xv_set(image_win->anima_canvas,
		    XV_X, 0,
		    XV_Y, 0,
		    XV_WIDTH, WIN_EXTEND_TO_EDGE,
		    XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		    NULL) ;
		/* redo image */
	    XDestroyImage(xim) ;
	    XFlush(display) ;
	    free(S_image_mem) ;
	    free(S_image_info.data) ;
	    S_image_mem = (unsigned char *) malloc(S_image_info.s_height*S_image_info.s_width*sizeof(char)) ;
            S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
            xim = XCreateImage(display,winv->visual,8,ZPixmap,0,
		           S_image_mem,S_image_info.s_width,S_image_info.s_height,16,0) ;
	    XFlush(display) ;
	    S_dont_repaint = repaint_status ;
        }
    }
    if (S_image_info.compression != S_CCC)
    {
	fprintf (stderr, "can't handle non-CCC format\n") ;
	exit(0) ;
    }
	/* if zoomed or unzoomed */
    if (S_zoom_changed)
    {
	repaint_status = S_dont_repaint ;
	S_dont_repaint = 1 ;
	S_zoom_changed = 0 ;
#ifdef MESSAGES
	fprintf (stderr, "new height, width = %d %d\n",S_image_info.s_height,S_image_info.s_width) ;
#endif
        (void) xv_set(image_win->win,
		XV_WIDTH, S_image_info.s_width,
		XV_HEIGHT, S_image_info.s_height,
		NULL) ;
	(void) xv_set(image_win->anima_canvas,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		NULL) ;
	XDestroyImage(xim) ;
	XFlush(display) ;
	free(S_image_mem) ;
	free(S_image_info.data) ;
	S_image_mem = (unsigned char *) malloc(S_image_info.s_height*S_image_info.s_width*sizeof(char)) ;
        S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
        xim = XCreateImage(display,winv->visual,8,ZPixmap,0,
		       S_image_mem,S_image_info.s_width,S_image_info.s_height,16,0) ;
	XFlush(display) ;
	S_dont_repaint = repaint_status ;
    }

    S_image_info.total = S_a_index[S_avars.current].buf_total ;
    
/* get the image */

    iff_read_buf(S_anima_file, &S_image_info);
    
    /* inform user that incorrect results are going to be generated */
    if (S_mapnum > S_maxcol)
    {
	fprintf (stderr,"incorrect colors result from a bad setting of the\n") ;
	fprintf (stderr,"maximum # of colors; restart Xanima with a larger\n") ;
	fprintf (stderr,"setting of the -c option\n") ;
	exit(0) ;
    }
	    /* get color map */
    for(i = 0; i < S_mapnum; i++)
    {
        red[i] = S_map[i][S_RED];
        green[i] = S_map[i][S_GREEN];
        blue[i] = S_map[i][S_BLUE];
    }


/* Display the current frame number in the panel. */
    sprintf(s, "%d/%d", S_avars.current, S_anima_count);
    xv_set(Xanima_control->number_text, PANEL_VALUE, s, 0);
    
/* Decompress the image and display it. */
    if (S_do_zoom)	/* zoom */
        zoom_decompress(S_image_info.data, S_image_mem, colors);
    else		/* normal */
        decompress_ccc(S_image_info.data, S_image_mem, S_image_info.s_height, S_image_info.s_width,colors);
	
	/* change gamma if it has been reset */
    if ((anima_format[0] == 'm') || S_avars.start || gamma_changed)
    {
	if (scry_gamma != 1.0)
	{
            for (i = 0; i < S_mapnum; i++)
	    {
	        red[i] = (int) (256. * pow((double) red[i] / 256., 1.0 / scry_gamma));
	        if (red[i] > 255)
	            red[i] = 255;
	        green[i] = (int) (256. * pow((double) green[i] / 256., 1.0 / scry_gamma));
	        if (green[i] > 255)
	            green[i] = 255;
	        blue[i] = (int) (256. * pow((double) blue[i] / 256., 1.0 / scry_gamma));
	        if (blue[i] > 255)
	            blue[i] = 255;
	    }
	}
        xv_set(image_win->anima_canvas,
	           WIN_CMS_NAME,"xanima",
	           WIN_CMS_DATA,&cms_data,
	           0) ;
	gamma_changed = 0 ;
    }

	/* display image */
    XPutImage(display,image_xid,
              gc,xim,0,0,0,0,S_image_info.s_width,S_image_info.s_height) ;

    if(S_avars.start == TRUE)
	S_avars.start = FALSE;
    S_dont_repaint = 0 ;
    return(1);
}
