/* convold.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdio.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_limits.h>


/* parse_args:	parse command-line arguments
   init_vars:	initialize various variables
   convert:	convert to new format
   conv_1to3:	convert old 8-bit image to 24-bit format */


static void parse_args();

char anima_format[80] ;	
char oldfilename[80] ;

struct image_stuff S_image_info ;		/* image (e.g. height, etc.) information */

unsigned char S_map[S_MAX_COL_SIZE][3] ;	/* RGB color map */
int S_mapnum ;			/* number of entries in color map */
int S_maxcol = S_MAX_COL_SIZE - 3  ;	/* maximum number of entries in color map */

extern long total1, total2 ;
extern long old_compression ;

unsigned char *bufout ;		/* holds new format image */

main(argc, argv)

int argc;
char *argv[];

{
    int i ;
    int buf_total ;
    FILE *oldfile = NULL ;
    
    init_vars();

        /* get command-line arguments */
    parse_args(argc, argv);
    if ((S_anima_file = fopen(S_anima_filename, "w")) == NULL)
    {
	fprintf (stderr,"can't open new file\n") ;
	exit(0) ;
    }
    
    if(oldfilename[0] != '\0')
    {
	    /* open old Anima file */
	get_old_footer(oldfilename,&oldfile) ;
    }
    S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
    bufout = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
    S_anima_bytes = 0 ;
	/* convert to new format */
    for (i = 0 ; i < S_anima_count ; i++)
    {
	printf ("%d\n",i) ;
	S_a_index[i].offset = S_anima_bytes ;
        convert (oldfile,&buf_total) ;
	S_a_index[i].buf_total = buf_total ;
    }
    free (S_image_info.data) ;
    free (bufout) ;
    anima_write_footer(S_anima_file) ;
    fclose(oldfile) ;
    fclose(S_anima_file) ;
}



/* parse command-line arguments */

static void
parse_args(argc, argv)

int argc;
char *argv[];

{
    int i;
    
    for(i = 1; i < argc; i++)
    {
	    if(*argv[i] != '-')
            {
		    fprintf(stderr,"bad command line:  use %s -h for help\n", argv[0]);
		    exit(-1);
            }
	    switch(*(argv[i]+1))
            {
		case 'i':		/* old Anima file */
		    strcpy(oldfilename, argv[++i]);
		    break;
		case 'o':               /* new Anima file */
		    strcpy(S_anima_filename, argv[++i]);
		    break;
		case 'h':
		    fprintf(stderr,"convert from old to new Anima format.\n");
		    fprintf(stderr,"Invoke with %s [args]\n", argv[0]);
		    fprintf(stderr,"-i file : old Anima file\n");
		    fprintf(stderr,"-o file : new Anima file\n");
		    fprintf(stderr,"-h : this message\n");
		    exit(-1);
		default:
		    fprintf(stderr,"bad command line:  use %s -h for help\n", argv[0]);
		    exit(-1);
        }
    }
}




init_vars()

{
    S_image_info.s_height = 400 ;
    S_image_info.s_width = 512 ;
    oldfilename[0] = '\0';
    S_anima_filename[0] = '\0' ;
    S_anima_file = NULL ;
    S_anima_bytes = 0 ;
    S_anima_count = 0 ;
}




/* convert an Anima frame from the 1.1 to the 1.2 format */

convert (oldfile,buf_total)

FILE *oldfile ;
int *buf_total ;	/* number of bytes in converted frame */

{
    int i, j, k ;
    int save_total ;
    unsigned char *bufin ;
    unsigned char *ptout ;
    unsigned char *convert_ccc() ;
    unsigned char *newimage = NULL ;
    unsigned char *compdata = NULL ;
    unsigned char *conv_1to3() ;
    short to_send[100] ;
    int last = 0 ;
    int datasize ;

        /* read old header */
    if (read_prelim (oldfile, &S_image_info) == 0)
    {
	perror ("read_prelim error") ;
	exit (0) ;
    }
	/* if not 8-bit Anima file */
    if (old_compression != S_QUANTIZE)
    {
	    /* read old color map */
	if (!read_old_map(oldfile))
	{
	    perror ("read_old_map error") ;
	    exit (0) ;
	}
    }
    save_total = S_image_info.total ;
	/* if has been Lempel-Ziv compressed */
    if (old_compression & S_LEMPEL_ZIV)
    {
	S_image_info.total = S_image_info.total_lz ;
	read_comp_buf(oldfile, &S_image_info) ;
	lzw_decomp (S_image_info.data,&S_image_info.total) ;
    }
    S_image_info.total = save_total ;
    if (!(old_compression & S_LEMPEL_ZIV))
    {
        if (old_compression != S_QUANTIZE)
	    read_comp_buf(oldfile, &S_image_info) ;
	else
	{
            fread(S_image_info.data, sizeof(char), S_image_info.s_width*S_image_info.s_height, oldfile);
            read_old_map(oldfile);
	    S_image_info.total = S_image_info.s_height * S_image_info.s_width ;
	}
    }
	/* if old-style CCC compressed */
    if (old_compression != S_QUANTIZE)
    {
	bufin = &(S_image_info.data[0]) ;
	ptout = bufout ;
	S_image_info.total = 0 ;
	for (i = 0 ; i < S_image_info.s_height ; i += 4 )
	{
	    init_newrun_length () ;
	    if (i == (S_image_info.s_height - 4))
		last = 1 ;
	    if (i == (S_image_info.s_height/2))
		bufin = S_image_info.data + total1 ;
		    /* CCC and run-length encode */
	    bufin = convert_ccc (bufin,&ptout,&(to_send[i/4]),last) ;
	    S_image_info.total += to_send[i/4] ;
	}
	*buf_total = S_image_info.total ;
	k = 0 ;
	i = S_image_info.total ;
	    /* flip image */
	for (j = 0 ; j < (S_image_info.s_height/4) ; j++)
	{
	    i -= to_send[j] ;
	    bcopy ((char *)&(bufout[k]),(char *)&(S_image_info.data[i]),to_send[j]) ;
	    k += to_send[j] ;
	}
    }
    else	/* 8-bit old Anima file */
    {
	newimage = conv_1to3(S_image_info.data,S_image_info.s_height,S_image_info.s_width) ;
	ccc_compress (newimage,S_image_info.data,&datasize,S_image_info.s_height,S_image_info.s_width) ;
	S_image_info.total = *buf_total = datasize ;
    }
    S_image_info.compression = S_CCC ;
    iff_write_header(S_anima_file,&S_image_info,S_image_info.s_height,
		     S_image_info.s_width,"many map Anima file") ;
    iff_write_buf(S_anima_file,&S_image_info) ;
}




/* convert an image from 8-bit to 24-bit RGB format */

unsigned char *
conv_1to3(image,height,width)

unsigned char *image ;
int height ;
int width ;

{
    unsigned char *newimage = NULL ;
    unsigned char *new_ptr ;
    unsigned char *old_ptr ;
    int old_depth = 1 ;
    int new_depth = 3 ;
    int i, j, k ;

    newimage = (unsigned char *) malloc (height*width*new_depth) ;
    for (k = 0 , i = 0 ; i < height ; i++, k++)
    {
	    /* flip image vertically */
        old_ptr = (unsigned char *)&(image[(((height-i-1)*width))*old_depth]) ;
	new_ptr = &(newimage[k*width*new_depth]) ;
	for (j = 0 ; j < width ; j++)
	{
            *new_ptr++ = S_map[*old_ptr+1][S_RED] ;
            *new_ptr++ = S_map[*old_ptr+1][S_GREEN] ;
            *new_ptr++ = S_map[*old_ptr+1][S_BLUE] ;
            ++old_ptr ;
	}
    }
    return (newimage) ;
}
