/* redoccc.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include 	 <stdio.h> 
#include	"imglib.h"
#include	<scry_anima.h>
#include        <scry_image.h>


/* reassign_ccc:  reassigns 2 colors for 4x4 CCC blocks using
		  the newly-generated single color map for all the frames
   init_run_length:  initialize run-length variables */


#define		SIZBLOC		4 	/* pixels per side of block */
#define		DEPTH		3	/* color resolution in bytes */


static int ccc_prev_color ;		/* color in a run */
static unsigned short ccc_run_ctr ;	/* run length */
static int ccc_finished ;		/* finished with a run */




/* reassigns 2 colors in each 4x4 CCC block using the newly-generated
   single color map for all the frames */

reassign_ccc (compdata,height,width,cpa,root)

unsigned char *compdata ;
int height ;
int width; 

Ctnode **cpa ;
Ctnode *root ;

{
    int	row = 0 ;			/* starting scan line */
    register unsigned char pix0, pix1 ;	/* old colors inside the block */
    unsigned char newpix0, newpix1 ;	/* new colors */
    register unsigned char *ptin ;	/* pointer for bufin */
    register unsigned short bitmap ;	/* bit map of one block */
    register unsigned char *ptc ;	/* pointer for ptbloc */
    register int i, j ;
    unsigned short run_ctr ;
    int block_width_num ;		/* number of blocks in row */
    int tot_blocks ;			/* total number of blocks in image */
    int decal ;				/* step to next scan line */
    unsigned char r0,g0,b0,r1,b1,g1 ;

    block_width_num = S_image_info.s_width/SIZBLOC ;
    tot_blocks = block_width_num * (S_image_info.s_height/SIZBLOC) ;
    decal = S_image_info.s_width - SIZBLOC + 1 ;
    ptin = compdata ;
    run_ctr = 0 ;
    for (i=0 ; i< tot_blocks ; i++)
    {
	    /* if not a run, or run finished */
        if (run_ctr == 0)	
        {
	    pix0 = *ptin++ ;
	    pix1 = *ptin++ ;
	    r0 = S_map[pix0][S_RED] ;
	    g0 = S_map[pix0][S_GREEN] ;
	    b0 = S_map[pix0][S_BLUE] ;
	    r1 = S_map[pix1][S_RED] ;
	    g1 = S_map[pix1][S_GREEN] ;
	    b1 = S_map[pix1][S_BLUE] ;
		/* reassign colors to those in final color map */
	    newpix0 = find_isi_color (r0,g0,b0,cpa,root) + 1 ;
	    newpix1 = find_isi_color (r1,g1,b1,cpa,root) + 1 ;
	    *(ptin-2) = newpix0 ;
	    *(ptin-1) = newpix1 ;
            if ( pix1 != pix0 )       /* if 2 colors different */
            { 
	        if (newpix0 != newpix1)	/* output bitmap */
	        {
	            run_ctr = 0 ;
	            bitmap = *ptin++ ;
	            bitmap = (bitmap << 8) | *ptin ;
	            ++ptin ;
	        }
	        else	/* a run length of 1 */
	        {
		    run_ctr = 0 ;
		    *ptin++ = 0 ;
		    *ptin++ = 1 ;
	        }
            }
            else	/* output run length */
            {
	        run_ctr = *ptin++ ;
	        run_ctr = (run_ctr << 8) | *ptin ;
	        ++ptin ;
	        --run_ctr ;
	    }
        }
        else
	    --run_ctr ;
    }
}




/* initialize run length variables */

init_run_length()

{
    ccc_prev_color = -1 ;
    ccc_run_ctr = 1 ;
    ccc_finished = 1 ;
}
